package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventQueryParams;
import cn.kinyun.customer.center.dto.resp.EventListResp;

import java.util.List;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/12/14
 */
public interface CcCustomerEventService {

    /**
     * 添加客户活动轨迹
     *
     * @param params
     */
    void add(CustomerEventReq params);

    /**
     * 添加数据互通事件
     *
     * @param params
     */
    void addBindRelation(CustomerEventReq params);

    /**
     * 添加数据互通事件
     *
     * @param bizId
     * @param source
     * @param list
     */
    void addBindRelations(Long bizId, String source, List<CustomerEventReq> list);

    /**
     * 批量添加客户活动轨迹
     *
     * @param bizId
     * @param source
     * @param list
     */
    void addBatch(Long bizId, String source, List<CustomerEventReq> list);

    /**
     * 客户活动轨迹
     *
     * @param params
     * @return
     */
    EventListResp list(EventQueryParams params);

    /**
     * 客户活动轨迹数量
     *
     * @param params
     * @return
     */
    int count(EventQueryParams params);

    /**
     * 页面访问记录事件需要更新
     * eventPage 事件需要更新访问时间等，根据accessNum来更新
     *
     * @param params
     */
    void updateVisitPage(CustomerEventReq params);
}
