package cn.kinyun.customer.center.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 模块来源类型
 *
 * @author lanye
 */
public enum ModuleType implements EnumService {

    LEADS_ADD(1, "leadsAdd", "客户录入"),

    LEADS_IMPORT(2, "leadsImport", "批量导入"),

    SMS(3, "sms", "短信"),

    CALL(4, "call", "外呼"),

    MARKETING_PLAN(5, "marketingPlan", "营销活动"),

    RADAR(6, "radar", "互动雷达"),

    DYNAMIC_FORM(7, "dynamicForm", "动态表单"),

    WEWORK_CONTACT(8, "weworkContact", "微信客户"),

    AD(9, "ad", "广告落地页"),

    TRADE(10, "trade", "商品订单"),

    BATCH_ADD_FRIEND(11, "batchAddFriend", "批量加好友"),

    API(12, "api", "API对接"),

    OFFICIAL(13, "official", "公众号"),

    REMARK_MOBILE(14, "remarkMobile", "人工备注手机号"),

    LIVE(15, "live", "直播"),
    WEWORK_AUTH(16, "weworkAuth", "企微授权"),
    MINI_PROGRAM_AUTH(17, "miniProgramAuth", "小程序授权"),
    OFFICIAL_ACCOUNT_AUTH(18, "officialAccountAuth", "公众号授权"),
    SHOP(19, "shop", "小商店"),
    BJY_WX(20, "bjy_wx", "百家云网校")
    ;

    private final int value;

    private final String code;

    private final String desc;

    ModuleType(int value, String code, String desc) {
        this.value = value;
        this.code = code;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, ModuleType> CACHE;

    static {
        Map<Integer, ModuleType> map = new HashMap<>();
        for (ModuleType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static ModuleType getType(Integer value) {
        return CACHE.get(value);
    }
}
