package cn.kinyun.customer.center.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 客户中心事件类型
 *
 * @author lanye
 */
public enum EventType implements EnumService {

    VISIT_PAGE(1, "visitPage", "用户访问页面"),

    ADD_MOBILE(2, "addMobile", "加手机号"),

    ADD_CONTACT(3, "addContact", "添加企微好友"),

    DEL_CONTACT(4, "delContact", "删除企微好友"),

    JOIN_ROOM(5, "joinRoom", "进群"),

    QUIT_ROOM(6, "quitRoom", "退群"),

    FANS_SUBSCRIBE(7, "fansSubscribe", "粉丝关注"),

    FANS_UNSUBSCRIBE(8, "fansUnSubscribe", "粉丝取消关注"),

    LIVE(9, "live", "直播"),

    PURCHASE_ORDER(10, "purchaseOrder", "购买订单"),

    PAY_ORDER(11, "payOrder", "支付订单"),

    ORDER_REFUND(12, "orderRefund", "退款"),

    SIGN_CONTRACT(13, "signContract", "签署合同"),

    BIND_RELATIONS(14, "bindRelations", "绑定客户中心id"),

    UNBIND_RELATIONS(15, "unbindRelations", "解绑客户中心id"),

    ;

    private final int value;

    private final String code;

    private final String desc;

    EventType(int value, String code, String desc) {
        this.value = value;
        this.code = code;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, EventType> CACHE;

    static {
        Map<Integer, EventType> map = new HashMap<>();
        for (EventType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static EventType getType(Integer value) {
        return CACHE.get(value);
    }
}
