package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/12/13
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SetBindingReq extends BaseReq {

    /**
     * 逻辑删除状态
     */
    private Integer isDeleted;

    /**
     * 解除绑定的时间
     */
    private Date deleteTime;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");
        if (source.equals("crm")) {
            Preconditions.checkArgument(userId != null, "userId不能为空");
        }
    }
}
