package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.exception.BusinessException;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * author: jw
 * date: 2022/4/19 上午11:00
 * content:
 */
@Data
public class EntryOrderConfigReq implements Serializable {
    private Long bizId;

    private String corpId;

    private Long userId;

    //来源
    private List<String> sources;

    private Integer extendFieldRequire;

    private List<String> extendField;

    private Integer mobileRequire;

    private Integer orderTimeRequire;

    private Integer nameRequire;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        Preconditions.checkArgument(userId != null, "userId不能为空");

        Preconditions.checkArgument(CollectionUtils.isNotEmpty(sources), "来源不能为空");
        //校验一下来源是否重复
        Set<String> sourceSet = sources.stream().collect(Collectors.toSet());
        if (sourceSet.size() < sources.size()) {
            throw new BusinessException(CommonErrorCode.PARAM_ERROR, "来源不能重复");
        }

        if (extendFieldRequire == null) {
            extendFieldRequire = 0;
        }
        Preconditions.checkArgument(extendFieldRequire == 0 || extendFieldRequire == 1, "参数extendFieldRequire不合法");

        if (extendFieldRequire == 1) {
            Preconditions.checkArgument(CollectionUtils.isNotEmpty(extendField), "业务扩展字段不能为空");
            Set<String> extendSet = extendField.stream().collect(Collectors.toSet());
            if (extendSet.size() < extendField.size()) {
                throw new BusinessException(CommonErrorCode.PARAM_ERROR, "扩展字段不能重复");
            }
        }

        if(mobileRequire == null) {
            mobileRequire = 0;
        }
        Preconditions.checkArgument(mobileRequire == 0 || mobileRequire == 1, "参数mobileRequire不合法");

        if(orderTimeRequire == null) {
            orderTimeRequire = 0;
        }

        Preconditions.checkArgument(orderTimeRequire == 0 || orderTimeRequire == 1, "参数mobileRequire不合法");

        if(nameRequire == null) {
            nameRequire = 0;
        }
        Preconditions.checkArgument(nameRequire == 0 || nameRequire == 1, "参数nameRequire不合法");
    }
}
