/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum PayOrderStatusEnum implements EnumService
{
    WAIT_PAY(1, "\u5f85\u652f\u4ed8", OrderStatusEnum.WAIT_PAY.getValue()),
    HAD_PAY(2, "\u5df2\u652f\u4ed8", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_DELIVERY(3, "\u5f85\u53d1\u8d27", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    SUCCESSED(4, "\u5df2\u6210\u529f", OrderStatusEnum.SUCCESSED.getValue()),
    CLOSED(5, "\u5df2\u5173\u95ed", OrderStatusEnum.CLOSED.getValue()),
    PARTIAL_PAY(6, "\u90e8\u5206\u652f\u4ed8", OrderStatusEnum.PARTIAL_PAY.getValue()),
    REFUNDED(7, "\u5df2\u9000\u6b3e", OrderStatusEnum.REFUNDED.getValue()),
    PARTIAL_REFUND(8, "\u90e8\u5206\u9000\u6b3e", OrderStatusEnum.REFUNDED.getValue());

    private final int id;
    private final String name;
    private final int orderStatus;
    private static final Map<Integer, PayOrderStatusEnum> CACHE;
    private static final Map<Integer, List<Integer>> statusCache;

    private PayOrderStatusEnum(int id, String name, int orderStatus) {
        this.id = id;
        this.name = name;
        this.orderStatus = orderStatus;
    }

    public int getValue() {
        return this.id;
    }

    public String getDesc() {
        return this.name;
    }

    public static PayOrderStatusEnum getByEnumName(String enumName) {
        PayOrderStatusEnum[] values;
        for (PayOrderStatusEnum value : values = PayOrderStatusEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.name(), (CharSequence)enumName)) continue;
            return value;
        }
        return null;
    }

    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    public static List<Integer> getScrmStatus(Integer id) {
        return statusCache.get(id);
    }

    public static PayOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }

    static {
        CACHE = new HashMap<Integer, PayOrderStatusEnum>(3);
        for (PayOrderStatusEnum item : PayOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<Integer, List<Integer>>();
        for (PayOrderStatusEnum item : PayOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }
}

