/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum RefundStatusEnum {
    WAIT_REFUND(0, "\u5f85\u9000\u6b3e"),
    NONE(1, "\u6b63\u5e38"),
    TRANSFERRING(2, "\u8f6c\u8bfe\u4e2d"),
    TRANSFERRED(3, "\u5df2\u8f6c\u8bfe"),
    REFUNDING(4, "\u9000\u8d39\u4e2d"),
    REFUNDED(5, "\u5df2\u9000\u6b3e"),
    FAIL(6, "\u5df2\u5931\u8d25"),
    REFUSE(7, "\u62d2\u7edd\u9000\u6b3e"),
    PART_REFUND(8, "\u90e8\u5206\u9000\u6b3e");

    private int value;
    private String desc;
    private static final Map<Integer, RefundStatusEnum> cache;
    private static final Map<Integer, RefundStatusEnum> innerMap;
    private static final Map<Integer, List<Integer>> queryMap;

    private RefundStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RefundStatusEnum get(int value) {
        return cache.get(value);
    }

    public static RefundStatusEnum statusEnumMap(int innerStatus) {
        return innerMap.get(innerStatus);
    }

    public static List<Integer> getQueryStatus(int outStatus) {
        return queryMap.get(outStatus);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        innerMap = Maps.newHashMap();
        queryMap = Maps.newHashMap();
        cache = new HashMap<Integer, RefundStatusEnum>();
        for (RefundStatusEnum item : RefundStatusEnum.values()) {
            cache.put(item.getValue(), item);
        }
        innerMap.put(RefundStatusEnum.WAIT_REFUND.value, WAIT_REFUND);
        innerMap.put(RefundStatusEnum.NONE.value, WAIT_REFUND);
        innerMap.put(RefundStatusEnum.REFUNDING.value, WAIT_REFUND);
        innerMap.put(RefundStatusEnum.REFUNDED.value, REFUNDED);
        innerMap.put(RefundStatusEnum.PART_REFUND.value, REFUNDED);
        innerMap.put(RefundStatusEnum.FAIL.value, WAIT_REFUND);
        innerMap.put(RefundStatusEnum.REFUSE.value, WAIT_REFUND);
        queryMap.put(RefundStatusEnum.WAIT_REFUND.value, Lists.newArrayList((Object[])new Integer[]{RefundStatusEnum.WAIT_REFUND.value, RefundStatusEnum.NONE.value, RefundStatusEnum.REFUNDING.value, RefundStatusEnum.FAIL.value, RefundStatusEnum.REFUSE.value}));
        queryMap.put(RefundStatusEnum.REFUNDED.value, Lists.newArrayList((Object[])new Integer[]{RefundStatusEnum.REFUNDED.value, RefundStatusEnum.PART_REFUND.value}));
    }
}

