/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CustomerBindReq
implements Serializable {
    private Long userId;
    private String weworkUserNum;
    private String customerNum;
    private String productLineId;
    private Integer isDeleted;
    private Date deleteTime;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.customerNum), (Object)"customerNum\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.weworkUserNum) || Objects.nonNull(this.userId) && this.userId > 0L ? 1 : 0) != 0, (Object)"weworkUserNum,userId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)this.weworkUserNum)) {
            this.weworkUserNum = "";
        }
        if (Objects.isNull(this.userId) || this.userId <= 0L) {
            this.userId = -1L;
        }
        Preconditions.checkArgument((Objects.nonNull(this.isDeleted) && this.isDeleted >= 0 && this.isDeleted <= 1 ? 1 : 0) != 0, (Object)"isDeleted is null or not valid");
        if (Objects.equals(this.isDeleted, NumberUtils.INTEGER_ZERO)) {
            this.deleteTime = null;
        }
        if (StringUtils.isBlank((CharSequence)this.productLineId)) {
            this.productLineId = "";
        }
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public String getCustomerNum() {
        return this.customerNum;
    }

    public String getProductLineId() {
        return this.productLineId;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public Date getDeleteTime() {
        return this.deleteTime;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setCustomerNum(String customerNum) {
        this.customerNum = customerNum;
    }

    public void setProductLineId(String productLineId) {
        this.productLineId = productLineId;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerBindReq)) {
            return false;
        }
        CustomerBindReq other = (CustomerBindReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        String this$customerNum = this.getCustomerNum();
        String other$customerNum = other.getCustomerNum();
        if (this$customerNum == null ? other$customerNum != null : !this$customerNum.equals(other$customerNum)) {
            return false;
        }
        String this$productLineId = this.getProductLineId();
        String other$productLineId = other.getProductLineId();
        if (this$productLineId == null ? other$productLineId != null : !this$productLineId.equals(other$productLineId)) {
            return false;
        }
        Date this$deleteTime = this.getDeleteTime();
        Date other$deleteTime = other.getDeleteTime();
        return !(this$deleteTime == null ? other$deleteTime != null : !((Object)this$deleteTime).equals(other$deleteTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerBindReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        String $customerNum = this.getCustomerNum();
        result = result * 59 + ($customerNum == null ? 43 : $customerNum.hashCode());
        String $productLineId = this.getProductLineId();
        result = result * 59 + ($productLineId == null ? 43 : $productLineId.hashCode());
        Date $deleteTime = this.getDeleteTime();
        result = result * 59 + ($deleteTime == null ? 43 : ((Object)$deleteTime).hashCode());
        return result;
    }

    public String toString() {
        return "CustomerBindReq(userId=" + this.getUserId() + ", weworkUserNum=" + this.getWeworkUserNum() + ", customerNum=" + this.getCustomerNum() + ", productLineId=" + this.getProductLineId() + ", isDeleted=" + this.getIsDeleted() + ", deleteTime=" + this.getDeleteTime() + ")";
    }
}

