package cn.kinyun.customer.center.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 这个service用于记录unionId变更的记录
 *
 * @author yanmaoyuan
 * @date 2023/4/28
 */
public interface UnionIdChangedService {

    /**
     * 异步记录unionId的改变
     *
     * 注意，这个方法在后台是异步执行，从调用接口到实际入库可能会存在一定的延迟。
     *
     * @param oldUnionId 原unionId
     * @param newUnionId 新unionId
     */
    void asyncRecord(String oldUnionId, String newUnionId);

    /**
     * 记录unionId的改变
     *
     * @param oldUnionId 原unionId
     * @param newUnionId 新unionId
     */
    void record(String oldUnionId, String newUnionId);

    /**
     * 根据unionId查询记录过改变的unionId
     *
     * @param unionId unionId
     * @return 记录过改变的unionId
     */
    List<String> getChangedUnionIds(String unionId);

    /**
     * 根据unionId批量查询记录过改变的unionId
     *
     * @param unionIds unionId
     * @return 记录过改变的unionId
     */
    Map<String, List<String>> getChangedUnionIdMap(Collection<String> unionIds);

    /**
     * 根据企微客户ID查询客户中心中记录的unionId，主要用于提前判断是否需要更新unionId。
     *
     * @param bizId 商户ID
     * @param contactId 客户ID
     * @return unionId，可能为null
     */
    String getUnionIdByWeworkContactId(Long bizId, String contactId);

    /**
     * 根据公众号的AppID和OpenID查询客户中心中记录的unionId，主要用于提前判断是否需要更新unionId。
     *
     * @param bizId 商户ID
     * @param appId AppID
     * @param openId OpenID
     * @return unionId，可能为null
     */
    String getUnionIdByOfficialFans(Long bizId, String appId, String openId);

    /**
     * 根据小程序的AppID和OpenID查询客户中心中记录的unionId，主要用于提前判断是否需要更新unionId。
     *
     * @param bizId 商户ID
     * @param appId AppID
     * @param openId OpenID
     * @return unionId，可能为null
     */
    String getUnionIdByMiniProgram(Long bizId, String appId, String openId);
}
