package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.operator.CustomerStageQueryReq;
import cn.kinyun.customer.center.dto.req.operator.CustomerTagQueryReq;
import cn.kinyun.customer.center.dto.req.operator.NewCustomerQueryReq;

/**
 * 客户中心算子服务
 */
public interface CcOperatorService {
    /**
     * 根据标签异步查询用户
     *
     * @param req
     * @return 返回查询的requestId
     */
    String customerTagAsync(CustomerTagQueryReq req);

    /**
     * 根据阶段异步查询用户
     *
     * @param req
     * @return 返回查询的requestId
     */
    String customerStageAsync(CustomerStageQueryReq req);


    /**
     * 查询首咨客户
     * @param req
     * @return 返回查询的requestId
     */
    String newCustomerAsync(NewCustomerQueryReq req);
}
