package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.*;
import cn.kinyun.customer.center.dto.resp.*;
import com.kuaike.common.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @Date: 2021/12/21 14:46
 * @Author: dayu
 */

public interface CcCustomerInfoService {

    /**
     *  查询客户基础信息
     * */
    CustomerDetailResp queryCustomerDetail(Long bizId, String customerNum);

    /**
     *  修改客户手机号
     * */
    void modCustomerMobiles(ModMobileReq req);

    void updateMobileByCustomerNum(Long bizId, String customerNum, String mobile);

    /**
     *  查询修改的手机号在系统绑定状态
     * */
    boolean queryBindStatus(QueryBindStatusReq req);

    /**
     *  查询客户最新阶段信息
     * */
    CustomerStageInfoResp queryCustomerStage(Long bizId, String customerNum);


    /**
     *  查询客户订单信息
     * */
    CustomerOrderResp queryOrderInfo(CustomerInfoPageReq pageReq);


    /**
     *  查询客户动态轨迹
     * */
    CustomerRouteResp queryCustomerRouteInfo(CustomerInfoPageReq baseReq);

    /**
     *  查询客户修改资料日志
     * */
    CustomerBasicInfoLog queryBasicLog(CustomerInfoPageReq pageReq);

    /**
     *  查询客户标签修改日志
     * */
    CustomerTagLog queryTagLog(CustomerInfoPageReq pageReq);

    /**
     *  查询客户绑定&释放记录日志
     * */
    CustomerReleaselog queryReleaseLog(CustomerInfoPageReq pageReq);

    /**
     *  查询客户继承日志
     * */
    CustomerInheritLog queryInheritLog(CustomerInfoPageReq pageReq);

    /**
     * 查询手机号对应的contactId
     */
    Map<String, String> queryContactIdByMobiles(Long bizId, Collection<String> mobiles);

}
