package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;

import java.util.Collection;
import java.util.List;

/**
 * @Date: 2021/12/20 17:13
 * @Author: dayu
 */

public interface CcCustomerDetailService {

    void add(CustomerDetailReq req);

    void addBatch(Long bizId, List<CustomerDetailReq> list);

    CustomerDetailResp queryCustomerDetail(Long bizId, String customerNum);

    List<CustomerDetailResp> queryCustomerDetails(Long bizId, Collection<String> customerNums);

    void updateCustomerDetail(ModMobileReq req, String corpId);

    void channelAssignment(Long bizId);

    List<CustomerDetailResp> queryCustomerDetailInfo(CustomerDetailReq req);


    /**
     * 同步电商平台的客户信息
     */
    String syncElectricPlatformCustomer(CustomerDetailReq req);

    /**
     * 同步电商平台的客户信息
     */
    void addOrderLeads(CustomerDetailReq req);

    /**
     * 查询推广人
     */
    Long getPromoterIdByCustomerNum(Long bizId, String customerNum);

    /**
     * 设置推广人
     */
    void setPromoterIdByCustomerNum(Long bizId, Long promoterId, String customerNum);


}
