package cn.kinyun.customer.center.service;

import cn.kinyun.customer.center.dto.req.BatchSetBindingReq;
import cn.kinyun.customer.center.dto.req.SetBindingReq;
import cn.kinyun.customer.center.dto.resp.CustomerBindingResp;

import java.util.List;

/**
 * desc: 客户绑定接口
 *
 * @author yanmaoyuan
 * @date 2021/12/10
 */
public interface CcCustomerBindService {

    /**
     * 设置客户绑定关系
     *
     * @param params
     */
    void setBinding(SetBindingReq params);

    /**
     * 批量设置客户绑定关系
     *
     * @param params
     */
    void batchSetBinding(BatchSetBindingReq params);

    /**
     * 查询客户绑定关系
     *
     * @param params
     * @return
     */
    List<CustomerBindingResp> binding(SetBindingReq params);


    /**
     * 取消指定商户下的绑定， 用于修复数据， 取消绑定后重新绑定一遍， 修复不同步的问题
     * @param bizId
     */
    void cancelBind(Long bizId);
}
