package cn.kinyun.customer.center.enums.electricity;

import cn.kinyun.customer.center.enums.RefundTypeEnum;
import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: lwl
 * @date: 2022/8/30
 * @description: 退款类型，有赞
 **/
public enum YzRefundTypeEnum implements EnumService {
    UNKNOWN(0, "UNKNOWN", "未知", RefundTypeEnum.UNKNOWN.getValue()),
    REFUND_ONLY(1, "REFUND_ONLY", "仅退款", RefundTypeEnum.WAY_BACK.getValue()),
    REFUND_AND_RETURN(2, "REFUND_AND_RETURN", "退货退款", RefundTypeEnum.WAY_BACK.getValue()),
    EXCHANGE_GOODS_FLOW(3, "EXCHANGE_GOODS_FLOW", "换货", RefundTypeEnum.UNKNOWN.getValue());

    private final int id;
    private final String key;
    private final String desc;
    private final Integer refundType;

    YzRefundTypeEnum(int id, String key, String desc, Integer refundType) {
        this.id = id;
        this.key = key;
        this.desc = desc;
        this.refundType = refundType;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public Integer getRefundType() {
        return refundType;
    }

    private static final Map<String, YzRefundTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzRefundTypeEnum item : YzRefundTypeEnum.values()) {
            CACHE.put(item.key, item);
        }
    }

    public static YzRefundTypeEnum get(String key) {
        if (!CACHE.containsKey(key)) {
            return UNKNOWN;
        }
        return CACHE.get(key);
    }
}
