package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 * @Description 有赞消息类型枚举类
 */
public enum YzMessageTypeEnum implements EnumService {

    APP_AUTH(1, "APP_AUTH", "应用授权", 0),
    APP_SUBSCRIBE(2, "APP_SUBSCRIBE", "订阅应用", 0),
    CLOUD_AUTH_CHANGE_MSG(3, "cloud_auth_change_msg", "店铺授权变更消息", 0),
    SCRM_CUSTOMER_EVENT(4, "SCRM_CUSTOMER_EVENT", "客户创建和更新时会触发事件通知", 0),
    OPEN_PUSH_SCRM_CUSTOMER_AUTH_MOBILE(5, "OPEN_PUSH_SCRM_CUSTOMER_AUTH_MOBILE", "客户手机号授权信息", 1),
    OPEN_PUSH_SCRM_MEMBER_MOBILE_CHANGE(6, "OPEN_PUSH_SCRM_MEMBER_MOBILE_CHANGE", "客户手机号变更", 0),
    YZ_CLOUD_CUSTOMERRELADD(7, "youzan_cloud_CustomerRelAdd", "客户关系创建消息", 0);

    private final int id;
    private final String type;
    private final String desc;
    /**
     * 是否收费
     */
    private final Integer charge;

    YzMessageTypeEnum(int id, String type, String desc, Integer charge) {
        this.id = id;
        this.type = type;
        this.desc = desc;
        this.charge = charge;
    }

    @Override
    public int getValue() {
        return id;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCharge() {
        return charge;
    }

    private static final Map<String, YzMessageTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (YzMessageTypeEnum item : YzMessageTypeEnum.values()) {
            CACHE.put(item.getType(), item);
        }
    }

    public static YzMessageTypeEnum get(String type) {
        return CACHE.get(type);
    }
}