package cn.kinyun.customer.center.enums.electricity;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * @Date: 2022/8/30 09:57
 * @Author: dayu
 */
public enum SoureChannelEnum implements EnumService {
    OTHER(0, "其他"),
    UNKNOW(1, "未知来源"),
    WECHAT(100, "微信"),
    WECHAT_PUBLIC(101, ""),
    WECHAT_APPLET(102, ""),
    WECHAT_CIRCLE(103, ""),
    WECHAT_TALK(104, "");

    private final int id;
    private final String name;

    SoureChannelEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }


    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, SoureChannelEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (SoureChannelEnum item : SoureChannelEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SoureChannelEnum get(int id) {
        return CACHE.get(id);
    }
}
