package cn.kinyun.customer.center.enums.electricity;

import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PayOrderStatusEnum implements EnumService {

    WAIT_PAY(1, "待支付", OrderStatusEnum.WAIT_PAY.getValue()),
    HAD_PAY(2, "已支付", OrderStatusEnum.HAD_PAY.getValue()),
    WAIT_DELIVERY(3, "待发货", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    SUCCESSED(4, "已成功", OrderStatusEnum.SUCCESSED.getValue()),
    CLOSED(5, "已关闭", OrderStatusEnum.CLOSED.getValue()),

    PARTIAL_PAY(6, "部分支付", OrderStatusEnum.PARTIAL_PAY.getValue()),

    REFUNDED(7, "已退款", OrderStatusEnum.REFUNDED.getValue()),

    PARTIAL_REFUND(8, "部分退款", OrderStatusEnum.REFUNDED.getValue());

    PayOrderStatusEnum(int id, String name, int orderStatus) {
        this.id = id;
        this.name = name;
        this.orderStatus = orderStatus;
    }

    private final int id;
    private final String name;

    private final int orderStatus;

    /**
     * 是否收费
     */

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }


    private static final Map<Integer, PayOrderStatusEnum> CACHE;

    private static final Map<Integer, List<Integer>> statusCache;

    static {
        CACHE = new HashMap<>(3);
        for (PayOrderStatusEnum item : PayOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }

        statusCache = new HashMap<>();
        for (PayOrderStatusEnum item : PayOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }

    public static PayOrderStatusEnum getByEnumName(String enumName) {
        PayOrderStatusEnum[] values = PayOrderStatusEnum.values();

        for (PayOrderStatusEnum value : values) {
            if (StringUtils.equals(value.name(), enumName)) {
                return value;
            }
        }
        return null;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public static List<Integer> getScrmStatus(Integer id) {
        return statusCache.get(id);
    }

    public static PayOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }
}