package cn.kinyun.customer.center.enums.electricity;

import com.google.common.collect.Lists;
import com.kuaike.common.enums.EnumService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author louis
 * @date 2022/10/13
 */
public enum DouOrderStatusEnum implements EnumService {

    TO_CONFIRM(1, "待确认/待支付-订单创建完毕", OrderStatusEnum.WAIT_PAY.getValue()),
    PAID(105, "已支付;", OrderStatusEnum.HAD_PAY.getValue()),
    STOCKING(2, "备货中", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    PART_DELIVERY(101, "部分发货", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    DELIVERY(3, "已发货（全部发货）", OrderStatusEnum.WAIT_DELIVERY.getValue()),
    CANCELED(4, "已取消", OrderStatusEnum.CLOSED.getValue()),
    TRADE_SUCCESS(5, "已完成（已收货）", OrderStatusEnum.SUCCESSED.getValue());

    DouOrderStatusEnum(int id, String name, int orderStatus) {
        this.id = id;
        this.name = name;
        this.orderStatus = orderStatus;
    }

    private final int id;
    private final String name;
    private final int orderStatus;

    /**
     * 是否收费
     */

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    private static final Map<Integer, DouOrderStatusEnum> CACHE;

    private static final Map<Integer, List<Integer>> statusCache;

    static {
        CACHE = new HashMap<>(3);
        for (DouOrderStatusEnum item : DouOrderStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
        statusCache = new HashMap<>();
        for (DouOrderStatusEnum item : DouOrderStatusEnum.values()) {
            List<Integer> statusList = statusCache.getOrDefault(item.getOrderStatus(), Lists.newArrayList());
            statusList.add(item.getValue());
            statusCache.put(item.getOrderStatus(), statusList);
        }
    }

    public static DouOrderStatusEnum getByEnumName(String enumName) {
        DouOrderStatusEnum[] values = DouOrderStatusEnum.values();

        for (DouOrderStatusEnum value : values) {
            if (StringUtils.equals(value.name(), enumName)) {
                return value;
            }
        }
        return null;
    }

    public static List<Integer> getDouOrderStatus(Integer id) {
        return statusCache.get(id);
    }

    public static DouOrderStatusEnum get(int id) {
        return CACHE.get(id);
    }

    /**
     * 获取已支付、待发货、已成功
     **/
    public static List<Integer> getPaidStatus(){
        List<Integer> statusList = Lists.newArrayList();
        List<Integer> hadPayList = getDouOrderStatus(OrderStatusEnum.HAD_PAY.getValue());
        List<Integer> waitList = getDouOrderStatus(OrderStatusEnum.WAIT_DELIVERY.getValue());
        List<Integer> successList = getDouOrderStatus(OrderStatusEnum.SUCCESSED.getValue());
        if (CollectionUtils.isNotEmpty(hadPayList)){
            statusList.addAll(hadPayList);
        }
        if (CollectionUtils.isNotEmpty(waitList)){
            statusList.addAll(waitList);
        }
        if (CollectionUtils.isNotEmpty(successList)){
            statusList.addAll(successList);
        }
        return statusList;
    }
}
