package cn.kinyun.customer.center.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zyl
 * <p>
 * 退转状态
 */
@Getter
public enum RefundStatusEnum {
    WAIT_REFUND(0, "待退款"),
    /**
     * 正常
     */
    NONE(1, "正常"),
    TRANSFERRING(2, "转课中"),
    TRANSFERRED(3, "已转课"),
    REFUNDING(4, "退费中"),
    REFUNDED(5, "已退款"),
    FAIL(6, "已失败"),
    REFUSE(7, "拒绝退款"),
    PART_REFUND(8, "部分退款");


    private int value;
    private String desc;

    RefundStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, RefundStatusEnum> cache;

    private static final Map<Integer, RefundStatusEnum> innerMap = Maps.newHashMap();

    private static final Map<Integer, List<Integer>> queryMap = Maps.newHashMap();

    static {
        cache = new HashMap<>();
        for (RefundStatusEnum item : RefundStatusEnum.values()) {
            cache.put(item.getValue(), item);
        }
        innerMap.put(WAIT_REFUND.value, WAIT_REFUND);
        innerMap.put(NONE.value, WAIT_REFUND);
        innerMap.put(REFUNDING.value, WAIT_REFUND);
        innerMap.put(REFUNDED.value, REFUNDED);
        innerMap.put(PART_REFUND.value, REFUNDED);
        innerMap.put(FAIL.value, WAIT_REFUND);
        innerMap.put(REFUSE.value, WAIT_REFUND);

        queryMap.put(WAIT_REFUND.value, Lists.newArrayList(WAIT_REFUND.value, NONE.value, REFUNDING.value, FAIL.value, REFUSE.value));
        queryMap.put(REFUNDED.value, Lists.newArrayList(REFUNDED.value, PART_REFUND.value));
    }

    public static RefundStatusEnum get(int value) {
        return cache.get(value);
    }

    public static RefundStatusEnum statusEnumMap(int innerStatus) {
        return innerMap.get(innerStatus);
    }

    public static List<Integer> getQueryStatus(int outStatus) {
        return queryMap.get(outStatus);
    }
}
