package cn.kinyun.customer.center.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2021/12/13
 **/
@Getter
public enum PayStatusEnum {
    /**
     * 未支付
     */
    UNPAID(1, "未支付"),

    PAYING(2, "支付中"),

    PAID(3, "已支付"),

    PART_PAID(4, "部分支付"),

    CANCELED(5, "已取消"),

    TIMEOUT(6, "超时未支付"),

    FAILED(7, "支付失败"),

    REFUND(8, "已退款"),

    CLOSED(9, "交易关闭");


    private int value;
    private String desc;

    PayStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, PayStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (PayStatusEnum item : PayStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static PayStatusEnum get(int value) {
        return CACHE.get(value);
    }
}
