package cn.kinyun.customer.center.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * desc: 客户标识类型
 *
 * @author yanmaoyuan
 * @date 2021/12/9
 */
public enum CustomerIdType {

    WEWORK_CONTACT_ID(0, "企微客户ID"),
    MOBILE(1, "手机号"),
    OFFICIAL_ACCOUNT_OPENID(2, "公众号AppId和OpenId"),
    MINI_PROGRAM_OPENID(3, "小程序AppId和OpenId"),
    H5_COOKIE(4, "H5页面cookie种的唯一键"),
    WEWORK_CONTACT_OPEN_ID(5, "企微授权得到的客户openId"),
    TAOBAO_OPEN_USER_ID(6,"淘宝小程序openUserId")

    ;
    private int value;
    private String desc;

    CustomerIdType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CustomerIdType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (CustomerIdType e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static CustomerIdType getType(Integer value) {
        return CACHE.get(value);
    }
}
