package cn.kinyun.customer.center.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 客户中心跟进类型
 *
 * @author lanye
 */
public enum CustomerFollowType implements EnumService {

    MOD_CUSTOMER(1, "编辑客户信息"),

    MOD_STAGE(2, "更新客户阶段"),

    MOD_FOLLOW(3, "编辑跟进信息"),

    MOD_TAG(4, "编辑标签"),

    INHERIT(5, "客户继承"),

    RADAR(6, "雷达"),

    LEADS_REFRESH(7, "线索刷新"),

    LEADS_BIND_OR_RELEASE(8, "线索绑定释放"),

    USER_FOLLOW(10, "主动跟进"),

    FORM_CUSTOMER_FOLLOW(11, "动态表单客户动态")

    ;

    private final int value;

    private final String desc;

    CustomerFollowType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CustomerFollowType> CACHE;

    static {
        Map<Integer, CustomerFollowType> map = new HashMap<>();
        for (CustomerFollowType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static CustomerFollowType getType(Integer value) {
        return CACHE.get(value);
    }
}
