package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.enums.RefundTypeEnum;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.exception.BusinessException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;


@Data
public class RefundOrderReq implements Serializable {
    private Long bizId;

    private Long userId;

    private String refundOrderNum;

    private String refundNo;

    private String customerNum;

    private String mobile;

    private String orderNo;

    //退款商品
    private List<String> refundSkus;

    //退款金额
    private Long refundAmount;

    //订单金额
    private Long orderAmount;

    //扣款金额
    private Long otherAmount;

    private Integer refundType;   //1 原路退回  2 银行转账

    //转账类型  alipayTransfer  bankTransfer
    private String transferType;

    private String accountName;

    private String account;

    private String bank;   //开户银行

    private String transferNo;  //转账流水号

    private List<String> transferAttachments;  //转转附件

    private String reason;

    private List<String> attachments;

    private String remark;

    //审批类型, 0 不用审批， 1 需要系统审批
    private Integer approvalType;

    //当前退款单需要审批的人员， 记录一下审批记录
    private List<Long> approvalUsers;

    private String refundSerialNo;   //退款流水号

    private String refundFailReason;


    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(orderNo), "订单编号不能为空");
        Preconditions.checkArgument(refundAmount != null, "退款金额不能为空");

        Preconditions.checkArgument(refundType != null, "退款方式不能为空");
        Preconditions.checkArgument(refundType == 1 || refundType == 2, "退款方式不对");

        if (refundType == RefundTypeEnum.TRANSFER.getValue()) {
            Preconditions.checkArgument(StringUtils.isNotBlank(transferType), "转账类型不能为空");
            Preconditions.checkArgument(StringUtils.isNotBlank(account), "转账账户不能为空");
        }
        Preconditions.checkArgument(StringUtils.isNotEmpty(reason), "退款原因不能为空");
    }
}