package cn.kinyun.customer.center.dto.req.order;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

/**
 * @author louis
 * @date 2023/3/22
 */
@Data
public class PayAmountReq implements Serializable {

    private static final long serialVersionUID = -6867940344650670212L;

    private Long bizId;

    private Date startTime;

    private Date endTime;

    private Collection<Long> userIds;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId),"bizId is null");
        Preconditions.checkArgument(Objects.nonNull(startTime),"startTime is null");
        Preconditions.checkArgument(Objects.nonNull(endTime),"endTime is null");

    }

}
