/**
 * kinyun.cn Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.customer.center.dto.req.order;

import cn.kinyun.customer.center.dto.req.BaseReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;


/**
 * @author lanye
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OrderSubmitReq extends BaseReq {

    private Integer platformCode;

    /**
     * 支付信息
     */
    private List<OrderRecordReq> orderRecordReqs;

    /**
     * 退款信息
     */
    private List<SetOrderRefundInfoReq> orderRefundInfoReqs;

    /**
     * 地址信息
     */
    private AddressReq addressReq;


    /**
     * 客户信息
     */
    private CustomerDetailReq customerDetailReq;

    /**
     * 线索信息
     */
    private CustomerDetailReq leadsReq;

    /**
     * 订单信息,可能会存在父子单信息
     */
    private List<OrderReq> orderReqs;


    /**
     * 物流信息
     */
    private List<LogisticsReq> logisticsReqs;


}