package cn.kinyun.customer.center.dto.req.order;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author louis
 * @date 2022/9/21
 */
@Data
public class LogisticsReq implements Serializable {

    private Long bizId;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 物流单号
     */
    private String trackingNo;

    /**
     * 物流公司
     */
    private String company;

    /**
     * 发货时间
     */
    private Date skipTime;

    /**
     * 包裹id
     */
    private String deliveryId;

    /**
     * 物流公司名称
     */
    private String companyName;



    public void checkParam() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(orderNo != null, "订单号 不能为空");
    }



}
