package cn.kinyun.customer.center.dto.req.operator;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class NewCustomerQueryReq implements Serializable {
    private Long bizId;

    /**
     * CRM的销售线ID
     */
    private String productLineId;

    /**
     * 员工
     */
    private List<Long> userIds;

    /**
     * 企业新客 1
     * 首次绑定线索 2
     * 企业新客和首次绑定线索  3
     */
    private int customerType;

    /***
     * 加好友时间范围
     */
    private Date addFriendStart;

    private Date addFriendEnd;

    /**
     * crm线索绑定时间范围
     */
    private Date bindStart;

    private Date bindEnd;

    public void valid() {
        Preconditions.checkArgument(bizId != null, "商户id不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(userIds), "员工不能为空");
        Preconditions.checkArgument(customerType == 1 || customerType == 2 || customerType == 3, "客户类型不满足");
    }
}
