package cn.kinyun.customer.center.dto.req.operator;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * @author Created by chenjiaqiang on 2023/01/07
 **/
@Data
public class CustomerStageQueryReq implements Serializable {

    private Long bizId;

    /**
     * CRM的销售线ID
     */
    private String productLineId;

    /**
     * userId - weworkUserNum
     */
    private Map<Long, String> userIdWeworkUserNumMap;

    /**
     * 阶段id 取并集
     */
    private Set<Long> stageIds;

    /**
     * 商户的第一个阶段id
     * customer_stage中 数据不完整
     */
    private Long firstStageId;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId),"bizId can not be null or empty");
        Preconditions.checkArgument(Objects.nonNull(firstStageId),"firstStageId can not be null or empty");
        Preconditions.checkArgument(!userIdWeworkUserNumMap.isEmpty(), "weworkUserNums can not be null or empty");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(stageIds), "tagGroups can not be null or empty");
    }

}
