package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * desc: 全量设置标签
 *
 * @author yanmaoyuan
 * @date 2021/12/10
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SetTagReq extends BaseReq {

    /**
     * 标签ID
     */
    private List<String> tagIds;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(tagIds), "tagIds不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(source), "source不能为空");
    }

}
