package cn.kinyun.customer.center.dto.req;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.exception.BusinessException;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author lixiaobin
 * @date 2024/10/9 14:15
 */

@Data
public class QueryOrderSkuDepPayRecordReportReq implements Serializable {

    private Date payTimeStart;

    private Date payTimeEnd;

    private Set<Long> departIds;

    private String skuName;

    private Long bizId;

    private List<String> skuNos;

    public void validate(){
        if(payTimeStart != null && payTimeEnd != null && payTimeStart.after(payTimeEnd)){
            throw new BusinessException(CommonErrorCode.PARAM_ERROR,"payTimeStart must be less than payTimeEnd");
        }
        if (bizId == null) {
            throw new BusinessException(CommonErrorCode.PARAM_ERROR,"bizId is null");
        }
    }
}
