package cn.kinyun.customer.center.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 客户归属基础信息
 *
 * @author lanye
 */
@Data
public class CustomerBindReq implements Serializable {

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 企业成员num（可选）
     */
    private String weworkUserNum;

    /**
     * 客户num
     */
    private String customerNum;

    /**
     * CRM的销售线ID
     */
    private String productLineId;

    /**
     * 逻辑删除状态
     */
    private Integer isDeleted;

    /**
     * 解除绑定的时间
     */
    private Date deleteTime;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(customerNum), "customerNum不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkUserNum) || (Objects.nonNull(userId) && userId > 0L), "weworkUserNum,userId不能同时为空");
        if (StringUtils.isBlank(weworkUserNum)) {
            weworkUserNum = "";
        }
        if (Objects.isNull(userId) || userId <= 0L) {
            userId = -1L;
        }
        Preconditions.checkArgument(Objects.nonNull(isDeleted) && isDeleted >= 0 && isDeleted <= 1, "isDeleted is null or not valid");
        if (Objects.equals(isDeleted, NumberUtils.INTEGER_ZERO)) {
            deleteTime = null;
        }
        if (StringUtils.isBlank(productLineId)) {
            productLineId = "";
        }
    }
}
