/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;

import java.util.List;

/**
 * @author yanmaoyuan
 * @date 2021/10/17
 */
public interface CrmProductLineService {

    /**
     * 查询销售线列表
     *
     * @param bizId 商户ID
     * @return 商户下的所有销售线
     */
    List<CrmProductLineResp> getListByBizId(Long bizId);

    /**
     * 查询销售线
     *
     * @param bizId 商户ID
     * @param num 唯一编号
     * @return 销售线
     */
    CrmProductLineResp getByNum(Long bizId, String num);

    /**
     * 查询销售线
     *
     * @param bizId 商户ID
     * @param id 唯一ID
     * @return 销售线
     */
    CrmProductLineResp getById(Long bizId, Long id);
}