/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.Classes;
import org.zkoss.zel.ImportHandler;

public class ImportedClassResolver
implements ClassResolver,
Serializable {
    private Map<String, Class<?>> _clses;
    private List<String> _pkgs;

    public void addImportedClass(String clsptn) throws ClassNotFoundException {
        String nm;
        if (clsptn == null || (clsptn = clsptn.trim()).length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        int j = clsptn.lastIndexOf(46);
        ImportHandler elih = ImportHandler.getImportHandler();
        if (j >= 0) {
            nm = clsptn.substring(j + 1);
            if ("*".equals(nm)) {
                String pkg;
                if (this._pkgs == null) {
                    this._pkgs = new LinkedList<String>();
                }
                if (!this._pkgs.contains(pkg = clsptn.substring(0, j + 1))) {
                    this._pkgs.add(pkg);
                }
                elih.importPackage(clsptn.substring(0, j));
                return;
            }
        } else {
            nm = clsptn;
        }
        elih.importClass(clsptn);
        if (this._clses == null) {
            this._clses = new HashMap(4);
        }
        this._clses.put(nm, Classes.forNameByThread(clsptn));
    }

    public List<String> getImportedClasses() {
        LinkedList<String> lst = new LinkedList<String>();
        if (this._clses != null) {
            for (Class clazz : this._clses.values()) {
                lst.add(clazz.getName());
            }
        }
        if (this._pkgs != null) {
            for (String string : this._pkgs) {
                lst.add(string + "*");
            }
        }
        return lst;
    }

    public void addAll(ImportedClassResolver resolver) {
        if (resolver._pkgs != null) {
            if (this._pkgs == null) {
                this._pkgs = new LinkedList<String>();
            }
            for (String pkg : resolver._pkgs) {
                if (this._pkgs.contains(pkg)) continue;
                this._pkgs.add(pkg);
            }
        }
        if (resolver._clses != null) {
            if (this._clses == null) {
                this._clses = new HashMap(4);
            }
            this._clses.putAll(resolver._clses);
        }
    }

    @Override
    public Class<?> resolveClass(String clsnm) throws ClassNotFoundException {
        if (clsnm.indexOf(46) < 0) {
            Class<?> cls;
            if (this._clses != null && (cls = this._clses.get(clsnm)) != null) {
                return cls;
            }
            if (this._pkgs != null) {
                for (String pkg : this._pkgs) {
                    try {
                        return Classes.forNameByThread(pkg + clsnm);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }
        return Classes.forNameByThread(clsnm);
    }
}

