/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tensorflow.lite.schema.Buffer;
import org.tensorflow.lite.schema.Metadata;
import org.tensorflow.lite.schema.Model;
import org.tensorflow.lite.schema.QuantizationParameters;
import org.tensorflow.lite.schema.SubGraph;
import org.tensorflow.lite.schema.Tensor;
import org.tensorflow.lite.support.metadata.MetadataExtractor;
import org.tensorflow.lite.support.metadata.Preconditions;

final class ModelInfo {
    private final Model model;
    private final List<Tensor> inputTensors;
    private final List<Tensor> outputTensors;
    static final String METADATA_FIELD_NAME = "TFLITE_METADATA";

    ModelInfo(ByteBuffer buffer) {
        ModelInfo.assertTFLiteModel(buffer);
        this.model = Model.getRootAsModel(buffer);
        Preconditions.checkArgument(this.model.subgraphsLength() > 0, "The model does not contain any subgraph.");
        this.inputTensors = ModelInfo.getInputTensors(this.model);
        this.outputTensors = ModelInfo.getOutputTensors(this.model);
    }

    @Nullable
    Tensor getInputTensor(int inputIndex) {
        Preconditions.checkArgument(inputIndex >= 0 && inputIndex < this.inputTensors.size(), "The inputIndex specified is invalid.");
        return this.inputTensors.get(inputIndex);
    }

    int getInputTensorCount() {
        return this.inputTensors.size();
    }

    int[] getInputTensorShape(int inputIndex) {
        Tensor tensor = this.getInputTensor(inputIndex);
        return ModelInfo.getShape(tensor);
    }

    byte getInputTensorType(int inputIndex) {
        return this.getInputTensor(inputIndex).type();
    }

    @Nullable
    ByteBuffer getMetadataBuffer() {
        if (this.model.metadataLength() == 0) {
            return null;
        }
        for (int i = 0; i < this.model.metadataLength(); ++i) {
            Metadata meta = this.model.metadata(i);
            if (!METADATA_FIELD_NAME.equals(meta.name())) continue;
            long bufferIndex = meta.buffer();
            Buffer metadataBuf = this.model.buffers((int)bufferIndex);
            return metadataBuf.dataAsByteBuffer();
        }
        return null;
    }

    @Nullable
    Tensor getOutputTensor(int outputIndex) {
        Preconditions.checkArgument(outputIndex >= 0 && outputIndex < this.outputTensors.size(), "The outputIndex specified is invalid.");
        return this.outputTensors.get(outputIndex);
    }

    int getOutputTensorCount() {
        return this.outputTensors.size();
    }

    int[] getOutputTensorShape(int outputIndex) {
        Tensor tensor = this.getOutputTensor(outputIndex);
        return ModelInfo.getShape(tensor);
    }

    byte getOutputTensorType(int outputIndex) {
        return this.getOutputTensor(outputIndex).type();
    }

    MetadataExtractor.QuantizationParams getQuantizationParams(Tensor tensor) {
        Preconditions.checkNotNull(tensor, "Tensor cannot be null.");
        QuantizationParameters quantization = tensor.quantization();
        if (quantization == null) {
            float scale = 0.0f;
            int zeroPoint = 0;
            return new MetadataExtractor.QuantizationParams(scale, zeroPoint);
        }
        Preconditions.checkArgument(quantization.scaleLength() <= 1, "Input and output tensors do not support per-channel quantization.");
        Preconditions.checkArgument(quantization.zeroPointLength() <= 1, "Input and output tensors do not support per-channel quantization.");
        float scale = quantization.scale(0);
        int zeroPoint = (int)quantization.zeroPoint(0);
        return new MetadataExtractor.QuantizationParams(scale, zeroPoint);
    }

    private static void assertTFLiteModel(ByteBuffer buffer) {
        Preconditions.checkNotNull(buffer, "Model flatbuffer cannot be null.");
        Preconditions.checkArgument(Model.ModelBufferHasIdentifier(buffer), "The identifier of the model is invalid. The buffer may not be a valid TFLite model flatbuffer.");
    }

    private static int[] getShape(Tensor tensor) {
        Preconditions.checkNotNull(tensor, "Tensor cannot be null.");
        int shapeDim = tensor.shapeLength();
        int[] tensorShape = new int[shapeDim];
        for (int i = 0; i < shapeDim; ++i) {
            tensorShape[i] = tensor.shape(i);
        }
        return tensorShape;
    }

    private static List<Tensor> getInputTensors(Model model) {
        SubGraph subgraph = model.subgraphs(0);
        int tensorNum = subgraph.inputsLength();
        ArrayList<Tensor> inputTensors = new ArrayList<Tensor>(tensorNum);
        for (int i = 0; i < tensorNum; ++i) {
            inputTensors.add(subgraph.tensors(subgraph.inputs(i)));
        }
        return Collections.unmodifiableList(inputTensors);
    }

    private static List<Tensor> getOutputTensors(Model model) {
        SubGraph subgraph = model.subgraphs(0);
        int tensorNum = subgraph.outputsLength();
        ArrayList<Tensor> outputTensors = new ArrayList<Tensor>(tensorNum);
        for (int i = 0; i < tensorNum; ++i) {
            outputTensors.add(subgraph.tensors(subgraph.outputs(i)));
        }
        return Collections.unmodifiableList(outputTensors);
    }
}

