/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeRole;
import org.opensearch.client.opensearch._types.PluginStats;
import org.opensearch.client.opensearch.nodes.info.NodeInfoAggregation;
import org.opensearch.client.opensearch.nodes.info.NodeInfoHttp;
import org.opensearch.client.opensearch.nodes.info.NodeInfoIngest;
import org.opensearch.client.opensearch.nodes.info.NodeInfoNetwork;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettings;
import org.opensearch.client.opensearch.nodes.info.NodeInfoTransport;
import org.opensearch.client.opensearch.nodes.info.NodeJvmInfo;
import org.opensearch.client.opensearch.nodes.info.NodeOperatingSystemInfo;
import org.opensearch.client.opensearch.nodes.info.NodeProcessInfo;
import org.opensearch.client.opensearch.nodes.info.NodeThreadPoolInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NodeInfo
implements PlainJsonSerializable {
    @Nullable
    private final Map<String, String> attributes;
    private final String buildHash;
    private final String buildType;
    private final String host;
    @Nullable
    private final NodeInfoHttp http;
    private final String ip;
    @Nullable
    private final NodeJvmInfo jvm;
    private final String name;
    @Nullable
    private final NodeInfoNetwork network;
    @Nullable
    private final NodeOperatingSystemInfo os;
    private final List<PluginStats> plugins;
    @Nullable
    private final NodeProcessInfo process;
    private final List<NodeRole> roles;
    @Nullable
    private final NodeInfoSettings settings;
    private final Map<String, NodeThreadPoolInfo> threadPool;
    @Nullable
    private final Long totalIndexingBuffer;
    @Nullable
    private final String totalIndexingBufferInBytes;
    @Nullable
    private final NodeInfoTransport transport;
    private final String transportAddress;
    private final String version;
    private final List<PluginStats> modules;
    @Nullable
    private final NodeInfoIngest ingest;
    private final Map<String, NodeInfoAggregation> aggregations;
    public static final JsonpDeserializer<NodeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfo::setupNodeInfoDeserializer);

    private NodeInfo(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.buildHash = ApiTypeHelper.requireNonNull(builder.buildHash, this, "buildHash");
        this.buildType = ApiTypeHelper.requireNonNull(builder.buildType, this, "buildType");
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.http = builder.http;
        this.ip = ApiTypeHelper.requireNonNull(builder.ip, this, "ip");
        this.jvm = builder.jvm;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.network = builder.network;
        this.os = builder.os;
        this.plugins = ApiTypeHelper.unmodifiable(builder.plugins);
        this.process = builder.process;
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.settings = builder.settings;
        this.threadPool = ApiTypeHelper.unmodifiable(builder.threadPool);
        this.totalIndexingBuffer = builder.totalIndexingBuffer;
        this.totalIndexingBufferInBytes = builder.totalIndexingBufferInBytes;
        this.transport = builder.transport;
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.modules = ApiTypeHelper.unmodifiable(builder.modules);
        this.ingest = builder.ingest;
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
    }

    public static NodeInfo of(Function<Builder, ObjectBuilder<NodeInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String buildHash() {
        return this.buildHash;
    }

    public final String buildType() {
        return this.buildType;
    }

    public final String host() {
        return this.host;
    }

    @Nullable
    public final NodeInfoHttp http() {
        return this.http;
    }

    public final String ip() {
        return this.ip;
    }

    @Nullable
    public final NodeJvmInfo jvm() {
        return this.jvm;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final NodeInfoNetwork network() {
        return this.network;
    }

    @Nullable
    public final NodeOperatingSystemInfo os() {
        return this.os;
    }

    public final List<PluginStats> plugins() {
        return this.plugins;
    }

    @Nullable
    public final NodeProcessInfo process() {
        return this.process;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final NodeInfoSettings settings() {
        return this.settings;
    }

    public final Map<String, NodeThreadPoolInfo> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public final Long totalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    @Nullable
    public final String totalIndexingBufferInBytes() {
        return this.totalIndexingBufferInBytes;
    }

    @Nullable
    public final NodeInfoTransport transport() {
        return this.transport;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final String version() {
        return this.version;
    }

    public final List<PluginStats> modules() {
        return this.modules;
    }

    @Nullable
    public final NodeInfoIngest ingest() {
        return this.ingest;
    }

    public final Map<String, NodeInfoAggregation> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("build_type");
        generator.write(this.buildType);
        generator.writeKey("host");
        generator.write(this.host);
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        generator.writeKey("ip");
        generator.write(this.ip);
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.network != null) {
            generator.writeKey("network");
            this.network.serialize(generator, mapper);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.plugins)) {
            generator.writeKey("plugins");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.plugins) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeThreadPoolInfo)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalIndexingBuffer != null) {
            generator.writeKey("total_indexing_buffer");
            generator.write(this.totalIndexingBuffer.longValue());
        }
        if (this.totalIndexingBufferInBytes != null) {
            generator.writeKey("total_indexing_buffer_in_bytes");
            generator.write(this.totalIndexingBufferInBytes);
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            this.transport.serialize(generator, mapper);
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("version");
        generator.write(this.version);
        if (ApiTypeHelper.isDefined(this.modules)) {
            generator.writeKey("modules");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.modules) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry entry : this.aggregations.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeInfoAggregation)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash");
        op.add(Builder::buildType, JsonpDeserializer.stringDeserializer(), "build_type");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::http, NodeInfoHttp._DESERIALIZER, "http");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(Builder::jvm, NodeJvmInfo._DESERIALIZER, "jvm");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::network, NodeInfoNetwork._DESERIALIZER, "network");
        op.add(Builder::os, NodeOperatingSystemInfo._DESERIALIZER, "os");
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins");
        op.add(Builder::process, NodeProcessInfo._DESERIALIZER, "process");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::settings, NodeInfoSettings._DESERIALIZER, "settings");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(NodeThreadPoolInfo._DESERIALIZER), "thread_pool");
        op.add(Builder::totalIndexingBuffer, JsonpDeserializer.longDeserializer(), "total_indexing_buffer");
        op.add(Builder::totalIndexingBufferInBytes, JsonpDeserializer.stringDeserializer(), "total_indexing_buffer_in_bytes");
        op.add(Builder::transport, NodeInfoTransport._DESERIALIZER, "transport");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::modules, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "modules");
        op.add(Builder::ingest, NodeInfoIngest._DESERIALIZER, "ingest");
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(NodeInfoAggregation._DESERIALIZER), "aggregations");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfo> {
        @Nullable
        private Map<String, String> attributes;
        private String buildHash;
        private String buildType;
        private String host;
        @Nullable
        private NodeInfoHttp http;
        private String ip;
        @Nullable
        private NodeJvmInfo jvm;
        private String name;
        @Nullable
        private NodeInfoNetwork network;
        @Nullable
        private NodeOperatingSystemInfo os;
        @Nullable
        private List<PluginStats> plugins;
        @Nullable
        private NodeProcessInfo process;
        private List<NodeRole> roles;
        @Nullable
        private NodeInfoSettings settings;
        @Nullable
        private Map<String, NodeThreadPoolInfo> threadPool;
        @Nullable
        private Long totalIndexingBuffer;
        @Nullable
        private String totalIndexingBufferInBytes;
        @Nullable
        private NodeInfoTransport transport;
        private String transportAddress;
        private String version;
        @Nullable
        private List<PluginStats> modules;
        @Nullable
        private NodeInfoIngest ingest;
        @Nullable
        private Map<String, NodeInfoAggregation> aggregations;

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        public final Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder http(@Nullable NodeInfoHttp value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<NodeInfoHttp.Builder, ObjectBuilder<NodeInfoHttp>> fn) {
            return this.http(fn.apply(new NodeInfoHttp.Builder()).build());
        }

        public final Builder ip(String value) {
            this.ip = value;
            return this;
        }

        public final Builder jvm(@Nullable NodeJvmInfo value) {
            this.jvm = value;
            return this;
        }

        public final Builder jvm(Function<NodeJvmInfo.Builder, ObjectBuilder<NodeJvmInfo>> fn) {
            return this.jvm(fn.apply(new NodeJvmInfo.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder network(@Nullable NodeInfoNetwork value) {
            this.network = value;
            return this;
        }

        public final Builder network(Function<NodeInfoNetwork.Builder, ObjectBuilder<NodeInfoNetwork>> fn) {
            return this.network(fn.apply(new NodeInfoNetwork.Builder()).build());
        }

        public final Builder os(@Nullable NodeOperatingSystemInfo value) {
            this.os = value;
            return this;
        }

        public final Builder os(Function<NodeOperatingSystemInfo.Builder, ObjectBuilder<NodeOperatingSystemInfo>> fn) {
            return this.os(fn.apply(new NodeOperatingSystemInfo.Builder()).build());
        }

        public final Builder plugins(List<PluginStats> list) {
            this.plugins = Builder._listAddAll(this.plugins, list);
            return this;
        }

        public final Builder plugins(PluginStats value, PluginStats ... values) {
            this.plugins = Builder._listAdd(this.plugins, value, values);
            return this;
        }

        public final Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        public final Builder process(@Nullable NodeProcessInfo value) {
            this.process = value;
            return this;
        }

        public final Builder process(Function<NodeProcessInfo.Builder, ObjectBuilder<NodeProcessInfo>> fn) {
            return this.process(fn.apply(new NodeProcessInfo.Builder()).build());
        }

        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder settings(@Nullable NodeInfoSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<NodeInfoSettings.Builder, ObjectBuilder<NodeInfoSettings>> fn) {
            return this.settings(fn.apply(new NodeInfoSettings.Builder()).build());
        }

        public final Builder threadPool(Map<String, NodeThreadPoolInfo> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        public final Builder threadPool(String key, NodeThreadPoolInfo value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        public final Builder threadPool(String key, Function<NodeThreadPoolInfo.Builder, ObjectBuilder<NodeThreadPoolInfo>> fn) {
            return this.threadPool(key, fn.apply(new NodeThreadPoolInfo.Builder()).build());
        }

        public final Builder totalIndexingBuffer(@Nullable Long value) {
            this.totalIndexingBuffer = value;
            return this;
        }

        public final Builder totalIndexingBufferInBytes(@Nullable String value) {
            this.totalIndexingBufferInBytes = value;
            return this;
        }

        public final Builder transport(@Nullable NodeInfoTransport value) {
            this.transport = value;
            return this;
        }

        public final Builder transport(Function<NodeInfoTransport.Builder, ObjectBuilder<NodeInfoTransport>> fn) {
            return this.transport(fn.apply(new NodeInfoTransport.Builder()).build());
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder modules(List<PluginStats> list) {
            this.modules = Builder._listAddAll(this.modules, list);
            return this;
        }

        public final Builder modules(PluginStats value, PluginStats ... values) {
            this.modules = Builder._listAdd(this.modules, value, values);
            return this;
        }

        public final Builder modules(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.modules(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        public final Builder ingest(@Nullable NodeInfoIngest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<NodeInfoIngest.Builder, ObjectBuilder<NodeInfoIngest>> fn) {
            return this.ingest(fn.apply(new NodeInfoIngest.Builder()).build());
        }

        public final Builder aggregations(Map<String, NodeInfoAggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, NodeInfoAggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<NodeInfoAggregation.Builder, ObjectBuilder<NodeInfoAggregation>> fn) {
            return this.aggregations(key, fn.apply(new NodeInfoAggregation.Builder()).build());
        }

        @Override
        public NodeInfo build() {
            this._checkSingleUse();
            return new NodeInfo(this);
        }
    }
}

