/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.fbx.AnimationList;
import com.jme3.scene.plugins.fbx.RotationOrder;
import com.jme3.scene.plugins.fbx.SceneKey;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.file.FbxFile;
import com.jme3.scene.plugins.fbx.file.FbxReader;
import com.jme3.scene.plugins.fbx.objects.FbxAnimCurve;
import com.jme3.scene.plugins.fbx.objects.FbxAnimNode;
import com.jme3.scene.plugins.fbx.objects.FbxBindPose;
import com.jme3.scene.plugins.fbx.objects.FbxCluster;
import com.jme3.scene.plugins.fbx.objects.FbxImage;
import com.jme3.scene.plugins.fbx.objects.FbxMaterial;
import com.jme3.scene.plugins.fbx.objects.FbxMesh;
import com.jme3.scene.plugins.fbx.objects.FbxNode;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import com.jme3.scene.plugins.fbx.objects.FbxSkin;
import com.jme3.scene.plugins.fbx.objects.FbxTexture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SceneLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private static final double secondsPerUnit = 2.165150866196751E-11;
    public static final boolean WARN_IGNORED_ATTRIBUTES = false;
    private List<String> warnings = new ArrayList<String>();
    private AnimationList animList;
    private String sceneName;
    public String sceneFilename;
    public String sceneFolderName;
    public AssetManager assetManager;
    public AssetInfo currentAssetInfo;
    private float animFrameRate;
    public float unitSize;
    public int xAxis = 1;
    public int yAxis = 1;
    public int zAxis = 1;
    private Map<Long, FbxObject> allObjects = new HashMap<Long, FbxObject>();
    private Map<Long, FbxSkin> skinMap = new HashMap<Long, FbxSkin>();
    private Map<Long, FbxObject> aLayerMap = new HashMap<Long, FbxObject>();
    public Map<Long, FbxNode> modelMap = new HashMap<Long, FbxNode>();
    private Map<Long, FbxNode> limbMap = new HashMap<Long, FbxNode>();
    private Map<Long, FbxBindPose> bindMap = new HashMap<Long, FbxBindPose>();
    private Map<Long, FbxMesh> geomMap = new HashMap<Long, FbxMesh>();
    private Skeleton skeleton;
    private AnimControl animControl;
    public Node sceneNode;

    public void warning(String warning) {
        this.warnings.add(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo assetInfo) throws IOException {
        this.currentAssetInfo = assetInfo;
        this.assetManager = assetInfo.getManager();
        AssetKey assetKey = assetInfo.getKey();
        if (assetKey instanceof SceneKey) {
            this.animList = ((SceneKey)assetKey).getAnimations();
        }
        InputStream stream = assetInfo.openStream();
        Node sceneNode = this.sceneNode = new Node(this.sceneName + "-scene");
        try {
            this.sceneFilename = assetKey.getName();
            this.sceneFolderName = assetKey.getFolder();
            String ext = assetKey.getExtension();
            this.sceneName = this.sceneFilename.substring(0, this.sceneFilename.length() - ext.length() - 1);
            if (this.sceneFolderName != null && this.sceneFolderName.length() > 0) {
                this.sceneName = this.sceneName.substring(this.sceneFolderName.length());
            }
            this.loadScene(stream);
            this.linkScene();
            if (this.warnings.size() > 0) {
                logger.log(Level.WARNING, "Model load finished with warnings:\n" + SceneLoader.join(this.warnings, "\n"));
            }
        }
        finally {
            this.releaseObjects();
            if (stream != null) {
                stream.close();
            }
        }
        return sceneNode;
    }

    private void loadScene(InputStream stream) throws IOException {
        logger.log(Level.FINE, "Loading scene {0}", this.sceneFilename);
        long startTime = System.currentTimeMillis();
        FbxFile scene = FbxReader.readFBX(stream);
        for (FbxElement e : scene.rootElements) {
            switch (e.id) {
                case "GlobalSettings": {
                    this.loadGlobalSettings(e);
                    break;
                }
                case "Objects": {
                    this.loadObjects(e);
                    break;
                }
                case "Connections": {
                    this.loadConnections(e);
                }
            }
        }
        long estimatedTime = System.currentTimeMillis() - startTime;
        logger.log(Level.FINE, "Loading done in {0} ms", estimatedTime);
    }

    private void loadGlobalSettings(FbxElement element) {
        for (FbxElement e2 : element.getFbxProperties()) {
            String propName;
            switch (propName = (String)e2.properties.get(0)) {
                case "UnitScaleFactor": {
                    this.unitSize = ((Double)e2.properties.get(4)).floatValue();
                    break;
                }
                case "CustomFrameRate": {
                    float framerate = ((Double)e2.properties.get(4)).floatValue();
                    if (framerate == -1.0f) break;
                    this.animFrameRate = framerate;
                    break;
                }
                case "UpAxisSign": {
                    this.yAxis = (Integer)e2.properties.get(4);
                    break;
                }
                case "FrontAxisSign": {
                    this.zAxis = (Integer)e2.properties.get(4);
                    break;
                }
                case "CoordAxisSign": {
                    this.xAxis = (Integer)e2.properties.get(4);
                }
            }
        }
    }

    private void loadObjects(FbxElement element) throws IOException {
        FbxObject obj = null;
        for (FbxElement e : element.children) {
            switch (e.id) {
                case "Geometry": {
                    FbxMesh mesh = new FbxMesh(this, e);
                    obj = mesh;
                    if (mesh.geometries == null) break;
                    this.geomMap.put(mesh.id, mesh);
                    break;
                }
                case "Material": {
                    obj = new FbxMaterial(this, e);
                    break;
                }
                case "Model": {
                    FbxNode node = new FbxNode(this, e);
                    obj = node;
                    this.modelMap.put(node.id, node);
                    if (!node.isLimb()) break;
                    this.limbMap.put(node.id, node);
                    break;
                }
                case "Pose": {
                    FbxBindPose pose = new FbxBindPose(this, e);
                    obj = pose;
                    this.bindMap.put(pose.id, pose);
                    break;
                }
                case "Texture": {
                    obj = new FbxTexture(this, e);
                    break;
                }
                case "Video": {
                    obj = new FbxImage(this, e);
                    break;
                }
                case "Deformer": {
                    obj = this.loadDeformer(e);
                    break;
                }
                case "AnimationLayer": {
                    FbxObject layer;
                    obj = layer = new FbxObject(this, e);
                    this.aLayerMap.put(layer.id, layer);
                    break;
                }
                case "AnimationCurve": {
                    obj = new FbxAnimCurve(this, e);
                    break;
                }
                case "AnimationCurveNode": {
                    obj = new FbxAnimNode(this, e);
                    break;
                }
                default: {
                    obj = null;
                }
            }
            if (obj == null) continue;
            this.allObjects.put(obj.id, obj);
        }
    }

    private FbxObject loadDeformer(FbxElement element) {
        String type;
        switch (type = (String)element.properties.get(2)) {
            case "Skin": {
                FbxSkin skinData = new FbxSkin(this, element);
                this.skinMap.put(skinData.id, skinData);
                return skinData;
            }
            case "Cluster": {
                FbxCluster clusterData = new FbxCluster(this, element);
                return clusterData;
            }
        }
        return null;
    }

    private void loadConnections(FbxElement element) {
        for (FbxElement e : element.children) {
            String type;
            if (!e.id.equals("C")) continue;
            switch (type = (String)e.properties.get(0)) {
                case "OO": {
                    long objId = (Long)e.properties.get(1);
                    long refId = (Long)e.properties.get(2);
                    FbxObject obj = this.allObjects.get(objId);
                    FbxObject ref = this.allObjects.get(refId);
                    if (ref != null) {
                        ref.link(obj);
                        break;
                    }
                    if (refId != 0L) break;
                    obj.linkToZero();
                    break;
                }
                case "OP": {
                    long objId = (Long)e.properties.get(1);
                    long refId = (Long)e.properties.get(2);
                    String propName = (String)e.properties.get(3);
                    FbxObject obj = this.allObjects.get(objId);
                    FbxObject ref = this.allObjects.get(refId);
                    if (ref == null) break;
                    ref.link(obj, propName);
                }
            }
        }
    }

    private void linkScene() {
        logger.log(Level.FINE, "Linking scene objects");
        long startTime = System.currentTimeMillis();
        this.applySkinning();
        this.buildAnimations();
        for (FbxMesh mesh : this.geomMap.values()) {
            mesh.clearMaterials();
        }
        for (FbxNode limb : this.limbMap.values()) {
            limb.node.removeFromParent();
        }
        long estimatedTime = System.currentTimeMillis() - startTime;
        logger.log(Level.FINE, "Linking done in {0} ms", estimatedTime);
    }

    private void applySkinning() {
        for (FbxBindPose fbxBindPose : this.bindMap.values()) {
            fbxBindPose.fillBindTransforms();
        }
        if (this.limbMap == null) {
            return;
        }
        ArrayList<Bone> bones = new ArrayList<Bone>();
        for (FbxNode limb : this.limbMap.values()) {
            if (limb.bone == null) continue;
            bones.add(limb.bone);
            limb.buildBindPoseBoneTransform();
        }
        this.skeleton = new Skeleton(bones.toArray(new Bone[bones.size()]));
        this.skeleton.setBindingPose();
        for (FbxNode limb : this.limbMap.values()) {
            limb.setSkeleton(this.skeleton);
        }
        for (FbxSkin skin : this.skinMap.values()) {
            skin.generateSkinning();
        }
        this.animControl = new AnimControl(this.skeleton);
        this.sceneNode.addControl((Control)this.animControl);
        SkeletonControl skeletonControl = new SkeletonControl(this.skeleton);
        this.sceneNode.addControl((Control)skeletonControl);
    }

    private void buildAnimations() {
        if (this.skeleton == null) {
            return;
        }
        if (this.animList == null || this.animList.list.size() == 0) {
            this.animList = new AnimationList();
            for (long layerId : this.aLayerMap.keySet()) {
                FbxObject layer = this.aLayerMap.get(layerId);
                this.animList.add(layer.name, layer.name, 0, -1);
            }
        }
        HashMap<String, Animation> anims = new HashMap<String, Animation>();
        for (AnimationList.AnimInverval animInfo : this.animList.list) {
            float realLength = 0.0f;
            float length = (float)(animInfo.lastFrame - animInfo.firstFrame) / this.animFrameRate;
            float animStart = (float)animInfo.firstFrame / this.animFrameRate;
            float animStop = (float)animInfo.lastFrame / this.animFrameRate;
            Animation anim = new Animation(animInfo.name, length);
            long sourceLayerId = 0L;
            Iterator<Object> iterator = this.aLayerMap.keySet().iterator();
            while (iterator.hasNext()) {
                long layerId = iterator.next();
                FbxObject layer = this.aLayerMap.get(layerId);
                if (!layer.name.equals(animInfo.layerName)) continue;
                sourceLayerId = layerId;
                break;
            }
            for (FbxNode limb : this.limbMap.values()) {
                Vector3f tvec;
                FbxAnimNode n;
                int i;
                int keyIndex;
                int i2;
                int keysCount;
                TreeSet<Long> stamps = new TreeSet<Long>();
                FbxAnimNode animTranslation = limb.animTranslation(sourceLayerId);
                FbxAnimNode animRotation = limb.animRotation(sourceLayerId);
                FbxAnimNode animScale = limb.animScale(sourceLayerId);
                boolean haveTranslation = SceneLoader.haveAnyChannel(animTranslation);
                boolean haveRotation = SceneLoader.haveAnyChannel(animRotation);
                boolean haveScale = SceneLoader.haveAnyChannel(animScale);
                if (haveTranslation) {
                    animTranslation.exportTimes(stamps);
                }
                if (haveRotation) {
                    animRotation.exportTimes(stamps);
                }
                if (haveScale) {
                    animScale.exportTimes(stamps);
                }
                if (stamps.isEmpty()) continue;
                long[] keyTimes = new long[stamps.size()];
                int cnt = 0;
                Iterator iterator2 = stamps.iterator();
                while (iterator2.hasNext()) {
                    long t = (Long)iterator2.next();
                    keyTimes[cnt++] = t;
                }
                int firstKeyIndex = 0;
                int lastKeyIndex = keyTimes.length - 1;
                for (int i3 = 0; i3 < keyTimes.length; ++i3) {
                    float time = (float)((double)keyTimes[i3] * 2.165150866196751E-11);
                    if (time <= animStart) {
                        firstKeyIndex = i3;
                    }
                    if (!(time >= animStop) || !(animStop >= 0.0f)) continue;
                    lastKeyIndex = i3;
                    break;
                }
                if ((keysCount = lastKeyIndex - firstKeyIndex + 1) <= 0) continue;
                float[] times = new float[keysCount];
                Vector3f[] translations = new Vector3f[keysCount];
                Quaternion[] rotations = new Quaternion[keysCount];
                Vector3f[] scales = null;
                for (i2 = 0; i2 < keysCount; ++i2) {
                    keyIndex = firstKeyIndex + i2;
                    float time = (float)((double)keyTimes[keyIndex] * 2.165150866196751E-11);
                    times[i2] = time - animStart;
                    realLength = Math.max(realLength, times[i2]);
                }
                if (haveTranslation) {
                    for (i2 = 0; i2 < keysCount; ++i2) {
                        keyIndex = firstKeyIndex + i2;
                        FbxAnimNode n2 = animTranslation;
                        Vector3f tvec2 = n2.getValue(keyTimes[keyIndex], n2.value).subtractLocal(n2.value);
                        translations[i2] = tvec2.divideLocal(this.unitSize);
                    }
                } else {
                    for (i2 = 0; i2 < keysCount; ++i2) {
                        translations[i2] = Vector3f.ZERO;
                    }
                }
                RotationOrder ro = RotationOrder.EULER_XYZ;
                if (haveRotation) {
                    for (i = 0; i < keysCount; ++i) {
                        int keyIndex2 = firstKeyIndex + i;
                        n = animRotation;
                        tvec = n.getValue(keyTimes[keyIndex2], n.value);
                        rotations[i] = ro.rotate(tvec);
                    }
                } else {
                    for (i = 0; i < keysCount; ++i) {
                        rotations[i] = Quaternion.IDENTITY;
                    }
                }
                if (haveScale) {
                    scales = new Vector3f[keysCount];
                    for (i = 0; i < keysCount; ++i) {
                        int keyIndex3 = firstKeyIndex + i;
                        n = animScale;
                        scales[i] = tvec = n.getValue(keyTimes[keyIndex3], n.value);
                    }
                }
                BoneTrack track = null;
                track = haveScale ? new BoneTrack(limb.boneIndex, times, translations, rotations, scales) : new BoneTrack(limb.boneIndex, times, translations, rotations);
                anim.addTrack((Track)track);
            }
            if (realLength != length && animInfo.lastFrame == -1) {
                Track[] tracks = anim.getTracks();
                if (tracks == null || tracks.length == 0) continue;
                anim = new Animation(animInfo.name, realLength);
                for (Track track : tracks) {
                    anim.addTrack(track);
                }
            }
            anims.put(anim.getName(), anim);
        }
        this.animControl.setAnimations(anims);
    }

    private void releaseObjects() {
        this.unitSize = 1.0f;
        this.animFrameRate = 30.0f;
        this.xAxis = 1;
        this.yAxis = 1;
        this.zAxis = 1;
        this.warnings.clear();
        this.animList = null;
        this.sceneName = null;
        this.sceneFilename = null;
        this.sceneFolderName = null;
        this.assetManager = null;
        this.currentAssetInfo = null;
        this.allObjects.clear();
        this.skinMap.clear();
        this.aLayerMap.clear();
        this.modelMap.clear();
        this.limbMap.clear();
        this.bindMap.clear();
        this.geomMap.clear();
        this.skeleton = null;
        this.animControl = null;
        this.sceneNode = null;
    }

    private static boolean haveAnyChannel(FbxAnimNode anims) {
        return anims != null && anims.haveAnyChannel();
    }

    private static String join(List<String> list, String glue) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (sb.length() != 0) {
                sb.append(glue);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }
}

