/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.zlmedia.restful;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.util.StringUtils;

public class ZLMediaConfigs {
    private static final List<String> ALL_HOOKS = Arrays.asList("on_flow_report", "on_http_access", "on_play", "on_publish", "on_record_mp4", "on_record_ts", "on_rtsp_auth", "on_rtsp_realm", "on_shell_login", "on_stream_changed", "on_stream_none_reader", "on_server_started", "on_server_exited", "on_server_keepalive", "on_send_rtp_stopped", "on_rtp_server_timeout", "on_stream_not_found");
    private String dataPath = "data/zlmedia";
    private String hookBasePath;
    private String hookParams = "";
    private Set<String> hooks = new HashSet<String>(ALL_HOOKS);
    private String serverId;
    private Ports ports = new Ports();
    private Map<String, String> others;
    private String secret = UUID.randomUUID().toString().replace("-", "");

    public Map<String, String> createConfigs() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("api.secret", this.secret);
        if (this.others != null) {
            configs.putAll(this.others);
        }
        if (this.serverId != null) {
            configs.put("general.mediaServerId", this.serverId);
        }
        if (this.hookBasePath != null) {
            configs.put("hook.enable", "1");
            Object prefix = this.hookBasePath;
            if (!((String)prefix).endsWith("/")) {
                prefix = (String)prefix + "/";
            }
            for (String hook : this.hooks) {
                String url = (String)prefix + hook;
                if (StringUtils.hasText((String)this.hookParams)) {
                    url = url + "?" + this.hookParams;
                }
                configs.put("hook." + hook, url);
            }
        }
        this.ports.applyConfig(configs);
        if (this.dataPath != null) {
            File file = new File(this.dataPath);
            String path = file.getAbsolutePath();
            configs.put("api.downloadRoot", path);
            configs.put("http.rootPath", path);
            configs.put("api.snapRoot", path + "/snapshot/");
            configs.put("api.defaultSnap", path + "/snapshot.png");
            configs.put("protocol.mp4_save_path", path);
            configs.put("protocol.hls_save_path", path);
        }
        return configs;
    }

    public void setConfig(String key, String value) {
        if (this.ports.setConfig(key, value)) {
            return;
        }
        switch (key) {
            case "api.secret": {
                this.secret = value;
                break;
            }
            case "general.mediaServerId": {
                this.serverId = value;
                break;
            }
            default: {
                if (this.others == null) break;
                this.others.put(key, value);
            }
        }
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getHookBasePath() {
        return this.hookBasePath;
    }

    public String getHookParams() {
        return this.hookParams;
    }

    public Set<String> getHooks() {
        return this.hooks;
    }

    public String getServerId() {
        return this.serverId;
    }

    public Ports getPorts() {
        return this.ports;
    }

    public Map<String, String> getOthers() {
        return this.others;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setHookBasePath(String hookBasePath) {
        this.hookBasePath = hookBasePath;
    }

    public void setHookParams(String hookParams) {
        this.hookParams = hookParams;
    }

    public void setHooks(Set<String> hooks) {
        this.hooks = hooks;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setPorts(Ports ports) {
        this.ports = ports;
    }

    public void setOthers(Map<String, String> others) {
        this.others = others;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public static class Ports {
        private int http = 8188;
        private int rtp = 10000;
        private int[] rtpRange = new int[]{30000, 35000};
        private int rtsp = 554;
        private int rtmp = 1935;
        private int rtc = 8000;
        private int srt = 9000;

        public boolean setConfig(String key, String value) {
            switch (key) {
                case "rtsp.port": {
                    this.setRtsp(Integer.parseInt(value));
                    return true;
                }
                case "rtmp.port": {
                    this.setRtmp(Integer.parseInt(value));
                    return true;
                }
                case "http.port": {
                    this.setHttp(Integer.parseInt(value));
                    return true;
                }
                case "rtp_proxy.port": {
                    this.setRtp(Integer.parseInt(value));
                    return true;
                }
                case "rtp_proxy.port_range": {
                    String[] range = value.split("-");
                    this.setRtpRange(new int[]{Integer.parseInt(range[0]), Integer.parseInt(range[1])});
                    return true;
                }
                case "rtc.port": {
                    this.setRtc(Integer.parseInt(value));
                    return true;
                }
                case "srt.port": {
                    this.setSrt(Integer.parseInt(value));
                    return true;
                }
            }
            return false;
        }

        public void applyConfig(Map<String, String> config) {
            config.put("http.port", String.valueOf(this.http));
            config.put("rtp_proxy.port", String.valueOf(this.rtp));
            config.put("rtp_proxy.port_range", this.rtpRange[0] + "-" + this.rtpRange[1]);
            config.put("rtsp.port", String.valueOf(this.rtsp));
            config.put("rtmp.port", String.valueOf(this.rtmp));
            config.put("rtc.port", String.valueOf(this.rtc));
            config.put("rtc.tcpPort", String.valueOf(this.rtc));
            config.put("srt.port", String.valueOf(this.srt));
        }

        public int getHttp() {
            return this.http;
        }

        public int getRtp() {
            return this.rtp;
        }

        public int[] getRtpRange() {
            return this.rtpRange;
        }

        public int getRtsp() {
            return this.rtsp;
        }

        public int getRtmp() {
            return this.rtmp;
        }

        public int getRtc() {
            return this.rtc;
        }

        public int getSrt() {
            return this.srt;
        }

        public void setHttp(int http) {
            this.http = http;
        }

        public void setRtp(int rtp) {
            this.rtp = rtp;
        }

        public void setRtpRange(int[] rtpRange) {
            this.rtpRange = rtpRange;
        }

        public void setRtsp(int rtsp) {
            this.rtsp = rtsp;
        }

        public void setRtmp(int rtmp) {
            this.rtmp = rtmp;
        }

        public void setRtc(int rtc) {
            this.rtc = rtc;
        }

        public void setSrt(int srt) {
            this.srt = srt;
        }
    }
}

