/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.llm.chat;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.GenericHeaderSupport;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.ai.cv.ImageData;

public class ChatResponse
extends GenericHeaderSupport<ChatResponse>
implements Externalizable {
    @Schema(title="\u54cd\u5e94\u7c7b\u578b")
    private Type type;
    @Schema(title="\u54cd\u5e94\u6587\u672c\u5185\u5bb9", description="\u5bf9\u8bdd\u6587\u672c\u6d88\u606f\u5185\u5bb9")
    private String content;
    @Schema(title="\u54cd\u5e94\u56fe\u7247\u5185\u5bb9", description="\u5bf9\u8bdd\u56fe\u7247\u6d88\u606f\u5185\u5bb9")
    private List<ImageData> images;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte(this.type.ordinal());
        SerializeUtils.writeKeyValue((Map)this.getHeaders(), (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.content, (ObjectOutput)out);
        if (this.images == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.images.size());
            for (ImageData image : this.images) {
                image.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte ignore = in.readByte();
        this.type = Type.ALL[in.readByte()];
        this.setHeaders(SerializeUtils.readMap((ObjectInput)in, ConcurrentHashMap::new));
        this.content = SerializeUtils.readNullableUTF((ObjectInput)in);
        int size = in.readInt();
        if (size > 0) {
            this.images = new ArrayList<ImageData>(size);
            for (int i = 0; i < size; ++i) {
                ImageData image = new ImageData();
                image.readExternal(in);
                this.images.add(image);
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public List<ImageData> getImages() {
        return this.images;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setImages(List<ImageData> images) {
        this.images = images;
    }

    public static enum Type {
        complete,
        streaming;

        static final Type[] ALL;

        static {
            ALL = Type.values();
        }
    }
}

