/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai.cv;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.file.FileData;
import org.springframework.util.StringUtils;

public class UploadFileInfo
implements FileData,
Externalizable {
    @Schema(description="\u6587\u4ef6\u7c7b\u578b")
    private String mediaType;
    @Schema(description="\u6587\u4ef6\u540d")
    private String fileName;
    @Schema(description="\u6587\u4ef6\u5730\u5740\uff0c\u4f20\u9012\u65b9\u5f0f\u4e3a\u6587\u4ef6\u5730\u5740\u65f6\u4f7f\u7528")
    private String url;
    @Schema(description="\u6587\u4ef6ID\uff0c\u4f20\u9012\u65b9\u5f0f\u4e3a\u4e0a\u4f20\u6587\u4ef6\u65f6\u4f7f\u7528")
    private String fileId;
    @Schema(description="\u6587\u4ef6\u6570\u636e\uff0c\u4f20\u9012\u65b9\u5f0f\u4e3a\u76f4\u63a5\u4f20\u8f93\u65f6\u4f7f\u7528")
    private ByteBuf data;
    @Schema(description="\u6587\u4ef6\u540e\u7f00")
    private String extension;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeNullableUTF((String)this.mediaType, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.fileName, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.url, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.fileId, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.data, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.extension, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mediaType = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.fileName = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.url = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.fileId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.data = (ByteBuf)SerializeUtils.readObject((ObjectInput)in);
        this.extension = SerializeUtils.readNullableUTF((ObjectInput)in);
    }

    @Override
    public String name() {
        if (StringUtils.hasText((String)this.fileName)) {
            return this.fileName;
        }
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        if (StringUtils.hasText((String)this.fileId)) {
            return this.fileId;
        }
        return "";
    }

    @Override
    public ByteBuf body() {
        return this.data == null ? null : Unpooled.unreleasableBuffer((ByteBuf)this.data);
    }

    @Override
    public void release() {
        ReferenceCountUtil.safeRelease((Object)this.data);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String getFileId() {
        return this.fileId;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

