/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.ai;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.utils.MetadataUtils;
import org.jetlinks.sdk.server.ai.AiOutputMetadataBuilder;
import org.jetlinks.sdk.server.ai.AiOutputMetadataType;
import org.springframework.core.ResolvableType;

public class AICommandHandler<C extends Command<R>, R>
implements CommandHandler<C, R> {
    private final Supplier<FunctionMetadata> description;
    private final BiFunction<C, CommandSupport, R> handler;
    private final Supplier<C> commandBuilder;
    private final Collection<PropertyMetadata> lightWeightProperties;
    private final Collection<PropertyMetadata> flatProperties;
    private final Collection<PropertyMetadata> flatLightWeightProperties;

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, AiOutputMetadataBuilder lightWeightProperties, AiOutputMetadataBuilder flatProperties, AiOutputMetadataBuilder flatLightWeightProperties) {
        Class<?> commandClass = ((Command)commandBuilder.get()).getClass();
        return AICommandHandler.of(metadata, executor, commandBuilder, lightWeightProperties.generateMetadata(commandClass), flatProperties.generateMetadata(commandClass), flatLightWeightProperties.generateMetadata(commandClass));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, AiOutputMetadataBuilder lightWeightProperties, AiOutputMetadataBuilder flatProperties) {
        Class<?> commandClass = ((Command)commandBuilder.get()).getClass();
        return AICommandHandler.of(metadata, executor, commandBuilder, lightWeightProperties.generateMetadata(commandClass), flatProperties.generateMetadata(commandClass));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, AiOutputMetadataBuilder lightWeightProperties) {
        Class<?> commandClass = ((Command)commandBuilder.get()).getClass();
        return AICommandHandler.of(metadata, executor, commandBuilder, lightWeightProperties.generateMetadata(commandClass));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, ResolvableType lightWeightProperties, ResolvableType flatProperties, ResolvableType flatLightWeightProperties) {
        return AICommandHandler.of(metadata, executor, commandBuilder, AICommandHandler.getClassMetadata(lightWeightProperties), AICommandHandler.getClassMetadata(flatProperties), AICommandHandler.getClassMetadata(flatLightWeightProperties));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, ResolvableType lightWeightProperties, ResolvableType flatProperties) {
        return AICommandHandler.of(metadata, executor, commandBuilder, AICommandHandler.getClassMetadata(lightWeightProperties), AICommandHandler.getClassMetadata(flatProperties));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, ResolvableType lightWeightProperties) {
        return AICommandHandler.of(metadata, executor, commandBuilder, AICommandHandler.getClassMetadata(lightWeightProperties));
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, Collection<PropertyMetadata> lightWeightProperties, Collection<PropertyMetadata> flatProperties, Collection<PropertyMetadata> flatLightWeightProperties) {
        return new AICommandHandler<C, R>(metadata, executor, commandBuilder, lightWeightProperties, flatProperties, flatLightWeightProperties);
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, Collection<PropertyMetadata> lightWeightProperties, Collection<PropertyMetadata> flatProperties) {
        return new AICommandHandler<C, R>(metadata, executor, commandBuilder, lightWeightProperties, flatProperties, flatProperties);
    }

    public static <R, C extends Command<R>> AICommandHandler<C, R> of(Supplier<FunctionMetadata> metadata, BiFunction<C, CommandSupport, R> executor, Supplier<C> commandBuilder, Collection<PropertyMetadata> properties) {
        return new AICommandHandler<C, R>(metadata, executor, commandBuilder, properties, properties, properties);
    }

    public Collection<PropertyMetadata> getAiOutputPropertyMetadata(AiOutputMetadataType type) {
        switch (type) {
            case flat: {
                return this.flatProperties;
            }
            case lightWeighFlat: {
                return this.flatLightWeightProperties;
            }
            case lightWeigh: {
                return this.lightWeightProperties;
            }
        }
        return Collections.emptyList();
    }

    public R handle(@Nonnull C command, @Nonnull CommandSupport support) {
        return this.handler.apply(command, support);
    }

    @Nonnull
    public C createCommand() {
        return (C)((Command)this.commandBuilder.get());
    }

    public FunctionMetadata getMetadata() {
        return this.description.get();
    }

    public static <T extends Command<?>> List<PropertyMetadata> getCommandOutputMetadata(Class<T> aclass) {
        ResolvableType responseDataType = CommandUtils.getCommandResponseDataType(aclass);
        return AICommandHandler.getClassMetadata(responseDataType);
    }

    public static List<PropertyMetadata> getClassMetadata(ResolvableType responseDataType) {
        DataType dataType = MetadataUtils.parseType((ResolvableType)responseDataType);
        if (dataType instanceof ObjectType) {
            return ((ObjectType)dataType).getProperties();
        }
        return Collections.emptyList();
    }

    public AICommandHandler(Supplier<FunctionMetadata> description, BiFunction<C, CommandSupport, R> handler, Supplier<C> commandBuilder, Collection<PropertyMetadata> lightWeightProperties, Collection<PropertyMetadata> flatProperties, Collection<PropertyMetadata> flatLightWeightProperties) {
        this.description = description;
        this.handler = handler;
        this.commandBuilder = commandBuilder;
        this.lightWeightProperties = lightWeightProperties;
        this.flatProperties = flatProperties;
        this.flatLightWeightProperties = flatLightWeightProperties;
    }

    public Collection<PropertyMetadata> getLightWeightProperties() {
        return this.lightWeightProperties;
    }

    public Collection<PropertyMetadata> getFlatProperties() {
        return this.flatProperties;
    }

    public Collection<PropertyMetadata> getFlatLightWeightProperties() {
        return this.flatLightWeightProperties;
    }
}

