/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.commons.cmd;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FileStreamCommand
extends Command<Flux<FileStream>> {
    default public boolean isAttachment() {
        return false;
    }

    public static Flux<FileStream> wrapResponse(String name, MediaType mediaType, Flux<ByteBuf> content) {
        Objects.requireNonNull(name, "name can not be null");
        Objects.requireNonNull(mediaType, "mediaType can not be null");
        return FileStreamCommand.wrapResponse(name, mediaType.toString(), content);
    }

    public static Flux<FileStream> wrapResponse(String name, String mediaType, Flux<ByteBuf> content) {
        Objects.requireNonNull(name, "name can not be null");
        Objects.requireNonNull(mediaType, "mediaType can not be null");
        return Flux.concat((Publisher[])new Publisher[]{Mono.just((Object)new FileStream(name, mediaType, null, null)), content.map(buf -> new FileStream(null, null, buf, null)).doOnDiscard(FileStream.class, FileStream::release)});
    }

    default public Mono<Void> executeAndWrite(CommandSupport support, ServerHttpResponse response) {
        return ((Flux)support.execute((Command)this)).switchOnFirst((signal, fileStreamFlux) -> {
            FileStream first;
            if (signal.hasValue() && (first = (FileStream)signal.get()) != null) {
                MediaType mediaType = MediaType.parseMediaType((String)first.mediaType);
                HttpHeaders headers = response.getHeaders();
                headers.setContentType(mediaType);
                if (this.isAttachment() || mediaType.includes(MediaType.APPLICATION_OCTET_STREAM)) {
                    headers.setContentDisposition(ContentDisposition.attachment().filename(first.getName(), StandardCharsets.UTF_8).build());
                }
                return response.writeWith((Publisher)fileStreamFlux.mapNotNull(FileStream::contentAsDataBuffer));
            }
            return fileStreamFlux.then(Mono.empty());
        }).then();
    }

    public static class FileStream
    implements Externalizable {
        @Schema(description="\u6587\u4ef6\u540d")
        private String name;
        @Schema(description="\u5a92\u4f53\u7c7b\u578b")
        private String mediaType;
        @Schema(description="\u6587\u4ef6\u5185\u5bb9")
        private Object content;
        @Schema(description="\u9884\u7559\u5176\u4ed6\u62d3\u5c55\u4fe1\u606f")
        private Map<String, Object> others;

        public DataBuffer contentAsDataBuffer() {
            return ConverterUtils.convertDataBuffer(this.content);
        }

        void release() {
            ReferenceCountUtil.safeRelease((Object)this.content);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            SerializeUtils.writeNullableUTF((String)this.name, (ObjectOutput)out);
            SerializeUtils.writeNullableUTF((String)this.mediaType, (ObjectOutput)out);
            SerializeUtils.writeObject((Object)this.content, (ObjectOutput)out);
            SerializeUtils.writeObject(this.others, (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = SerializeUtils.readNullableUTF((ObjectInput)in);
            this.mediaType = SerializeUtils.readNullableUTF((ObjectInput)in);
            this.content = SerializeUtils.readObject((ObjectInput)in);
            this.others = (Map)SerializeUtils.readObject((ObjectInput)in);
        }

        public String getName() {
            return this.name;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public Object getContent() {
            return this.content;
        }

        public Map<String, Object> getOthers() {
            return this.others;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public void setOthers(Map<String, Object> others) {
            this.others = others;
        }

        private FileStream(String name, String mediaType, Object content, Map<String, Object> others) {
            this.name = name;
            this.mediaType = mediaType;
            this.content = content;
            this.others = others;
        }

        public static FileStream of(String name, String mediaType, Object content, Map<String, Object> others) {
            return new FileStream(name, mediaType, content, others);
        }

        public FileStream() {
        }
    }
}

