/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DateFormatFeature
implements ValueMapFeature {
    private static final String ID = FeatureId.ValueMap.of("date_format").getId();

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        net.sf.jsqlparser.expression.Function now = (net.sf.jsqlparser.expression.Function)expression;
        try {
            ZoneId tz;
            List expres = now.getParameters().getExpressions();
            if (expres.size() < 2) {
                throw new UnsupportedOperationException("\u9519\u8bef\u7684\u53c2\u6570,\u6b63\u786e\u4f8b\u5b50: date_format(date,'yyyy-MM-dd')");
            }
            Expression val = (Expression)expres.get(0);
            Expression formatExpr = (Expression)expres.get(1);
            ZoneId zoneId = tz = expres.size() > 2 ? ZoneId.of(((StringValue)expres.get(2)).getValue()) : ZoneId.systemDefault();
            if (formatExpr instanceof StringValue) {
                Function<ReactorQLRecord, Publisher<?>> mapper = ValueMapFeature.createMapperNow(val, metadata);
                StringValue format = (StringValue)formatExpr;
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format.getValue());
                return ctx -> Mono.from((Publisher)((Publisher)mapper.apply((ReactorQLRecord)ctx))).map(value -> formatter.format(CastUtils.castDate(value).toInstant().atZone(tz)));
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("\u9519\u8bef\u7684\u53c2\u6570,\u6b63\u786e\u4f8b\u5b50: date_format(date,'yyyy-MM-dd','Asia/Shanghai')", e);
        }
        throw new UnsupportedOperationException("\u9519\u8bef\u7684\u53c2\u6570,\u6b63\u786e\u4f8b\u5b50: date_format(date,'yyyy-MM-dd')");
    }

    @Override
    public String getId() {
        return ID;
    }
}

