/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.jetlinks.reactor.ql.feature.PropertyFeature;
import org.jetlinks.reactor.ql.supports.map.CastFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.reactor.ql.utils.SqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyFeature
implements PropertyFeature {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropertyFeature.class);
    public static final DefaultPropertyFeature GLOBAL = new DefaultPropertyFeature();
    private static final Pattern splitPattern = Pattern.compile("[.]");
    private static final Pattern castPattern = Pattern.compile("::");

    protected String[] splitDot(String str, int limit) {
        return splitPattern.split(str, limit);
    }

    protected String[] splitCast(String str) {
        return castPattern.split(str);
    }

    @Override
    public Optional<Object> getProperty(Object property, Object source) {
        Object direct;
        if (source == null) {
            return Optional.empty();
        }
        if (property instanceof String) {
            property = SqlUtils.getCleanStr((String)property);
        }
        if ("this".equals(property) || "$".equals(property) || "*".equals(property)) {
            return Optional.of(source);
        }
        if (property instanceof Number) {
            int index = ((Number)property).intValue();
            return Optional.ofNullable(CastUtils.castArray(source).get(index));
        }
        Function<Object, Object> mapper = Function.identity();
        String strProperty = String.valueOf(property);
        if (strProperty.contains("::")) {
            String[] cast = this.splitCast(strProperty);
            strProperty = cast[0];
            mapper = v -> CastFeature.castValue(v, cast[1]);
        }
        if ((direct = this.doGetProperty0(strProperty, source)) != null) {
            return Optional.of(direct).map(mapper);
        }
        Object tmp = source;
        String[] props = this.splitDot(strProperty, 2);
        if (props.length <= 1) {
            return Optional.empty();
        }
        while (props.length > 1) {
            if ((tmp = this.doGetProperty0(props[0], tmp)) == null) {
                return Optional.empty();
            }
            Object fast = this.doGetProperty0(props[1], tmp);
            if (fast != null) {
                return Optional.of(fast).map(mapper);
            }
            if (props[1].contains(".")) {
                props = this.splitDot(props[1], 2);
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(tmp).map(mapper);
    }

    private Object doGetProperty0(String property, Object value) {
        if ("this".equals(property) || "$".equals(property)) {
            return value;
        }
        if (value instanceof Map) {
            Object val = ((Map)value).get(property);
            if (val == null) {
                switch (property) {
                    case "$size": 
                    case "size": {
                        return ((Map)value).size();
                    }
                    case "$empty": 
                    case "empty": {
                        return ((Map)value).isEmpty();
                    }
                    case "$keys": 
                    case "keys": {
                        return ((Map)value).keySet();
                    }
                    case "$values": 
                    case "values": {
                        return ((Map)value).values();
                    }
                    case "$entries": 
                    case "entries": {
                        return Collections2.transform(((Map)value).entrySet(), e -> {
                            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                            map.put("key", e.getKey());
                            map.put("value", e.getValue());
                            return map;
                        });
                    }
                }
            }
            return val;
        }
        if (value instanceof Collection) {
            if (property.startsWith("[") && property.endsWith("]")) {
                property = property.substring(1, property.length() - 1);
            }
            switch (property) {
                case "$size": 
                case "size": {
                    return ((Collection)value).size();
                }
                case "$empty": 
                case "empty": {
                    return ((Collection)value).isEmpty();
                }
            }
            Number number = CastUtils.castNumber(property, v -> null);
            if (number != null) {
                int idx = number.intValue();
                return this.getValueFromCollection(idx, (Collection)value);
            }
            return null;
        }
        return this.doGetProperty(property, value);
    }

    protected Object getValueFromCollection(int index, Collection<?> conn) {
        if (index < 0) {
            index = conn.size() + index;
        }
        if (index < 0 || index >= conn.size()) {
            return null;
        }
        if (conn instanceof List) {
            return ((List)conn).get(index);
        }
        return conn.stream().skip(index).findFirst().orElse(null);
    }

    protected Object doGetProperty(String property, Object value) {
        try {
            return PropertyUtils.getProperty((Object)value, (String)property);
        }
        catch (Exception e) {
            log.warn("get property [{}] from {} error {}", new Object[]{property, value, e.toString()});
            return null;
        }
    }
}

