/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote;

import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.naming.event.ServerListChangedEvent;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.utils.SignUtil;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractNamingClientProxy
extends Subscriber<ServerListChangedEvent>
implements NamingClientProxy {
    private static final String APP_FILED = "app";
    private static final String SIGNATURE_FILED = "signature";
    private static final String DATA_FILED = "data";
    private static final String AK_FILED = "ak";
    private static final String SEPARATOR = "@@";
    private final SecurityProxy securityProxy;
    private final Properties properties;

    protected AbstractNamingClientProxy(SecurityProxy securityProxy, Properties properties) {
        this.securityProxy = securityProxy;
        this.properties = properties;
    }

    protected Map<String, String> getSecurityHeaders() {
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((String)this.securityProxy.getAccessToken())) {
            result.put("accessToken", this.securityProxy.getAccessToken());
        }
        return result;
    }

    protected Map<String, String> getSpasHeaders(String serviceName) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        String ak = this.getAccessKey();
        String sk = this.getSecretKey();
        result.put(APP_FILED, AppNameUtils.getAppName());
        if (StringUtils.isNotBlank((String)ak) && StringUtils.isNotBlank((String)sk)) {
            try {
                String signData = this.getSignData(serviceName);
                String signature = SignUtil.sign(signData, sk);
                result.put(SIGNATURE_FILED, signature);
                result.put(DATA_FILED, signData);
                result.put(AK_FILED, ak);
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("inject ak/sk failed.", (Throwable)e);
            }
        }
        return result;
    }

    private String getAccessKey() {
        if (this.properties == null) {
            return SpasAdapter.getAk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("accessKey"), SpasAdapter::getAk);
    }

    private String getSecretKey() {
        if (this.properties == null) {
            return SpasAdapter.getSk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("secretKey"), SpasAdapter::getSk);
    }

    private String getSignData(String serviceName) {
        return StringUtils.isNotEmpty((String)serviceName) ? System.currentTimeMillis() + SEPARATOR + serviceName : String.valueOf(System.currentTimeMillis());
    }
}

