/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.api;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.dto.DataLogDTO;
import org.jeecg.common.api.dto.OnlineAuthDTO;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.api.dto.message.TemplateMessageDTO;
import org.jeecg.common.system.api.factory.SysBaseAPIFallbackFactory;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.system.vo.SysFilesModel;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(contextId="sysBaseRemoteApi", value="jeecg-system", fallbackFactory=SysBaseAPIFallbackFactory.class)
@ConditionalOnMissingClass(value={"org.jeecg.modules.system.service.impl.SysBaseApiImpl"})
public interface ISysBaseAPI
extends CommonAPI {
    @PostMapping(value={"/sys/api/sendSysAnnouncement"})
    public void sendSysAnnouncement(@RequestBody MessageDTO var1);

    @PostMapping(value={"/sys/api/sendBusAnnouncement"})
    public void sendBusAnnouncement(@RequestBody BusMessageDTO var1);

    @PostMapping(value={"/sys/api/sendTemplateAnnouncement"})
    public void sendTemplateAnnouncement(@RequestBody TemplateMessageDTO var1);

    @PostMapping(value={"/sys/api/sendBusTemplateAnnouncement"})
    public void sendBusTemplateAnnouncement(@RequestBody BusTemplateMessageDTO var1);

    @PostMapping(value={"/sys/api/parseTemplateByCode"})
    public String parseTemplateByCode(@RequestBody TemplateDTO var1);

    @GetMapping(value={"/sys/api/getUserById"})
    public LoginUser getUserById(@RequestParam(value="id") String var1);

    @GetMapping(value={"/sys/api/getRolesByUsername"})
    public List<String> getRolesByUsername(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/getDepartIdsByUsername"})
    public List<String> getDepartIdsByUsername(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/getDepartNamesByUsername"})
    public List<String> getDepartNamesByUsername(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/queryDictItemsByCode"})
    public List<DictModel> queryDictItemsByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/sys/api/queryEnableDictItemsByCode"})
    public List<DictModel> queryEnableDictItemsByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/sys/api/queryAllDict"})
    public List<DictModel> queryAllDict();

    @GetMapping(value={"/sys/api/queryAllSysCategory"})
    public List<SysCategoryModel> queryAllSysCategory();

    @GetMapping(value={"/sys/api/queryTableDictItemsByCode"})
    public List<DictModel> queryTableDictItemsByCode(@RequestParam(value="table") String var1, @RequestParam(value="text") String var2, @RequestParam(value="code") String var3);

    @GetMapping(value={"/sys/api/queryAllDepartBackDictModel"})
    public List<DictModel> queryAllDepartBackDictModel();

    @GetMapping(value={"/sys/api/updateSysAnnounReadFlag"})
    public void updateSysAnnounReadFlag(@RequestParam(value="busType") String var1, @RequestParam(value="busId") String var2);

    @GetMapping(value={"/sys/api/queryFilterTableDictInfo"})
    public List<DictModel> queryFilterTableDictInfo(@RequestParam(value="table") String var1, @RequestParam(value="text") String var2, @RequestParam(value="code") String var3, @RequestParam(value="filterSql") String var4);

    @Deprecated
    @GetMapping(value={"/sys/api/queryTableDictByKeys"})
    public List<String> queryTableDictByKeys(@RequestParam(value="table") String var1, @RequestParam(value="text") String var2, @RequestParam(value="code") String var3, @RequestParam(value="keyArray") String[] var4);

    @GetMapping(value={"/sys/api/queryAllUserBackCombo"})
    public List<ComboModel> queryAllUserBackCombo();

    @GetMapping(value={"/sys/api/queryAllUser"})
    public JSONObject queryAllUser(@RequestParam(name="userIds", required=false) String var1, @RequestParam(name="pageNo", required=false) Integer var2, @RequestParam(name="pageSize", required=false) int var3);

    @GetMapping(value={"/sys/api/queryAllRole"})
    public List<ComboModel> queryAllRole(@RequestParam(name="roleIds", required=false) String[] var1);

    @GetMapping(value={"/sys/api/getRoleIdsByUsername"})
    public List<String> getRoleIdsByUsername(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/getDepartIdsByOrgCode"})
    public String getDepartIdsByOrgCode(@RequestParam(value="orgCode") String var1);

    @GetMapping(value={"/sys/api/getAllSysDepart"})
    public List<SysDepartModel> getAllSysDepart();

    @GetMapping(value={"/sys/api/getParentDepartId"})
    public DictModel getParentDepartId(@RequestParam(value="departId") String var1);

    @GetMapping(value={"/sys/api/getDeptHeadByDepId"})
    public List<String> getDeptHeadByDepId(@RequestParam(value="deptId") String var1);

    @GetMapping(value={"/sys/api/sendWebSocketMsg"})
    public void sendWebSocketMsg(@RequestParam(value="userIds") String[] var1, @RequestParam(value="cmd") String var2);

    @GetMapping(value={"/sys/api/queryAllUserByIds"})
    public List<LoginUser> queryAllUserByIds(@RequestParam(value="userIds") String[] var1);

    @GetMapping(value={"/sys/api/meetingSignWebsocket"})
    public void meetingSignWebsocket(@RequestParam(value="userId") String var1);

    @GetMapping(value={"/sys/api/queryUserByNames"})
    public List<LoginUser> queryUserByNames(@RequestParam(value="userNames") String[] var1);

    @GetMapping(value={"/sys/api/getUserRoleSet"})
    public Set<String> getUserRoleSet(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/getUserPermissionSet"})
    public Set<String> getUserPermissionSet(@RequestParam(value="username") String var1);

    @PostMapping(value={"/sys/api/hasOnlineAuth"})
    public boolean hasOnlineAuth(@RequestBody OnlineAuthDTO var1);

    @GetMapping(value={"/sys/api/selectAllById"})
    public SysDepartModel selectAllById(@RequestParam(value="id") String var1);

    @GetMapping(value={"/sys/api/queryDeptUsersByUserId"})
    public List<String> queryDeptUsersByUserId(@RequestParam(value="userId") String var1);

    @GetMapping(value={"/sys/api/queryUserRoles"})
    public Set<String> queryUserRoles(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/queryUserAuths"})
    public Set<String> queryUserAuths(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/getDynamicDbSourceById"})
    public DynamicDataSourceModel getDynamicDbSourceById(@RequestParam(value="dbSourceId") String var1);

    @GetMapping(value={"/sys/api/getDynamicDbSourceByCode"})
    public DynamicDataSourceModel getDynamicDbSourceByCode(@RequestParam(value="dbSourceCode") String var1);

    @GetMapping(value={"/sys/api/getUserByName"})
    public LoginUser getUserByName(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/translateDictFromTable"})
    public String translateDictFromTable(@RequestParam(value="table") String var1, @RequestParam(value="text") String var2, @RequestParam(value="code") String var3, @RequestParam(value="key") String var4);

    @GetMapping(value={"/sys/api/translateDict"})
    public String translateDict(@RequestParam(value="code") String var1, @RequestParam(value="key") String var2);

    @GetMapping(value={"/sys/api/queryPermissionDataRule"})
    public List<SysPermissionDataRuleModel> queryPermissionDataRule(@RequestParam(value="component") String var1, @RequestParam(value="requestPath") String var2, @RequestParam(value="username") String var3);

    @GetMapping(value={"/sys/api/getCacheUser"})
    public SysUserCacheInfo getCacheUser(@RequestParam(value="username") String var1);

    @GetMapping(value={"/sys/api/queryUsersByUsernames"})
    public List<JSONObject> queryUsersByUsernames(@RequestParam(value="usernames") String var1);

    @RequestMapping(value={"/sys/api/queryUsersByIds"})
    public List<JSONObject> queryUsersByIds(@RequestParam(value="ids") String var1);

    @RequestMapping(value={"/sys/api/queryDepartsByOrgcodes"})
    public List<JSONObject> queryDepartsByOrgcodes(@RequestParam(value="orgCodes") String var1);

    @GetMapping(value={"/sys/api/sendEmailMsg"})
    public void sendEmailMsg(@RequestParam(value="email") String var1, @RequestParam(value="title") String var2, @RequestParam(value="content") String var3);

    @GetMapping(value={"/sys/api/getDeptUserByOrgCode"})
    public List<Map> getDeptUserByOrgCode(@RequestParam(value="orgCode") String var1);

    @GetMapping(value={"/sys/api/loadCategoryDictItem"})
    public List<String> loadCategoryDictItem(@RequestParam(value="ids") String var1);

    @GetMapping(value={"/sys/api/loadDictItem"})
    public List<String> loadDictItem(@RequestParam(value="dictCode") String var1, @RequestParam(value="keys") String var2);

    @GetMapping(value={"/sys/api/getDictItems"})
    public List<DictModel> getDictItems(@RequestParam(value="dictCode") String var1);

    @RequestMapping(value={"/sys/api/getManyDictItems"})
    public Map<String, List<DictModel>> getManyDictItems(@RequestParam(value="dictCodeList") List<String> var1);

    @GetMapping(value={"/sys/api/loadDictItemByKeyword"})
    public List<DictModel> loadDictItemByKeyword(@RequestParam(value="dictCode") String var1, @RequestParam(value="keyword") String var2, @RequestParam(value="pageSize", required=false) Integer var3);

    @GetMapping(value={"/sys/api/queryDepartsByIds"})
    public List<JSONObject> queryDepartsByIds(@RequestParam(value="ids") String var1);

    @GetMapping(value={"/sys/api/translateManyDict"})
    public Map<String, List<DictModel>> translateManyDict(@RequestParam(value="dictCodes") String var1, @RequestParam(value="keys") String var2);

    @GetMapping(value={"/sys/api/translateDictFromTableByKeys"})
    public List<DictModel> translateDictFromTableByKeys(@RequestParam(value="table") String var1, @RequestParam(value="text") String var2, @RequestParam(value="code") String var3, @RequestParam(value="keys") String var4);

    @PostMapping(value={"/sys/api/sendTemplateMessage"})
    public void sendTemplateMessage(@RequestBody MessageDTO var1);

    @GetMapping(value={"/sys/api/getTemplateContent"})
    public String getTemplateContent(@RequestParam(value="code") String var1);

    @PostMapping(value={"/sys/api/saveDataLog"})
    public void saveDataLog(DataLogDTO var1);

    @PostMapping(value={"/sys/api/addSysFiles"})
    public void addSysFiles(SysFilesModel var1);

    @GetMapping(value={"/sys/api/getFileUrl"})
    public String getFileUrl(@RequestParam(name="fileId") String var1);

    @PutMapping(value={"/updateAvatar"})
    public void updateAvatar(@RequestBody LoginUser var1);

    @GetMapping(value={"/sendAppChatSocket"})
    public void sendAppChatSocket(@RequestParam(name="userId") String var1);
}

