/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.desform.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import org.bson.Document;
import org.bson.json.Converter;
import org.bson.json.JsonWriterSettings;
import org.jeecg.common.desform.vo.def.BigDecimalVoConverter;

public class DesignFormDataVo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final BigDecimalVoConverter BIG_DECIMAL_CONVERTER = new BigDecimalVoConverter();
    private String id;
    private String desformId;
    private String desformCode;
    private String desformName;
    private String desformDataJson;
    private JSONObject desformData;
    private String onlineFormCode;
    private String onlineFormDataId;
    private String bpmStatus;
    private String createBy;
    private Date createTime;
    private String updateBy;
    private Date updateTime;
    private boolean isTriggerProcess = true;

    public DesignFormDataVo(String desformCode, Document document) {
        JsonWriterSettings writerSettings = JsonWriterSettings.builder().decimal128Converter((Converter)BIG_DECIMAL_CONVERTER).build();
        this.parseDataByJson(desformCode, JSON.parseObject((String)document.toJson(writerSettings)));
    }

    public DesignFormDataVo(String desformCode, JSONObject jsonData) {
        this.parseDataByJson(desformCode, jsonData);
    }

    public DesignFormDataVo() {
    }

    public String getDesformDataJson() {
        if (this.desformData == null) {
            return this.desformDataJson;
        }
        return this.desformData.toJSONString();
    }

    private void parseDataByJson(String desformCode, JSONObject jsonData) {
        this.desformCode = desformCode;
        this.id = jsonData.getString("_id");
        this.desformId = jsonData.getString("desform_id");
        this.desformName = jsonData.getString("desform_name");
        this.onlineFormCode = jsonData.getString("online_form_code");
        this.onlineFormDataId = jsonData.getString("online_form_id");
        this.bpmStatus = jsonData.getString("bpm_status");
        this.createBy = jsonData.getString("create_by");
        this.createTime = jsonData.getDate("create_time");
        this.updateBy = jsonData.getString("update_by");
        this.updateTime = jsonData.getDate("update_time");
        this.desformData = jsonData;
    }

    public String getId() {
        return this.id;
    }

    public String getDesformId() {
        return this.desformId;
    }

    public String getDesformCode() {
        return this.desformCode;
    }

    public String getDesformName() {
        return this.desformName;
    }

    public JSONObject getDesformData() {
        return this.desformData;
    }

    public String getOnlineFormCode() {
        return this.onlineFormCode;
    }

    public String getOnlineFormDataId() {
        return this.onlineFormDataId;
    }

    public String getBpmStatus() {
        return this.bpmStatus;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public boolean isTriggerProcess() {
        return this.isTriggerProcess;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDesformId(String desformId) {
        this.desformId = desformId;
    }

    public void setDesformCode(String desformCode) {
        this.desformCode = desformCode;
    }

    public void setDesformName(String desformName) {
        this.desformName = desformName;
    }

    public void setDesformDataJson(String desformDataJson) {
        this.desformDataJson = desformDataJson;
    }

    public void setDesformData(JSONObject desformData) {
        this.desformData = desformData;
    }

    public void setOnlineFormCode(String onlineFormCode) {
        this.onlineFormCode = onlineFormCode;
    }

    public void setOnlineFormDataId(String onlineFormDataId) {
        this.onlineFormDataId = onlineFormDataId;
    }

    public void setBpmStatus(String bpmStatus) {
        this.bpmStatus = bpmStatus;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setTriggerProcess(boolean isTriggerProcess) {
        this.isTriggerProcess = isTriggerProcess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DesignFormDataVo)) {
            return false;
        }
        DesignFormDataVo other = (DesignFormDataVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTriggerProcess() != other.isTriggerProcess()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$desformId = this.getDesformId();
        String other$desformId = other.getDesformId();
        if (this$desformId == null ? other$desformId != null : !this$desformId.equals(other$desformId)) {
            return false;
        }
        String this$desformCode = this.getDesformCode();
        String other$desformCode = other.getDesformCode();
        if (this$desformCode == null ? other$desformCode != null : !this$desformCode.equals(other$desformCode)) {
            return false;
        }
        String this$desformName = this.getDesformName();
        String other$desformName = other.getDesformName();
        if (this$desformName == null ? other$desformName != null : !this$desformName.equals(other$desformName)) {
            return false;
        }
        String this$desformDataJson = this.getDesformDataJson();
        String other$desformDataJson = other.getDesformDataJson();
        if (this$desformDataJson == null ? other$desformDataJson != null : !this$desformDataJson.equals(other$desformDataJson)) {
            return false;
        }
        JSONObject this$desformData = this.getDesformData();
        JSONObject other$desformData = other.getDesformData();
        if (this$desformData == null ? other$desformData != null : !this$desformData.equals(other$desformData)) {
            return false;
        }
        String this$onlineFormCode = this.getOnlineFormCode();
        String other$onlineFormCode = other.getOnlineFormCode();
        if (this$onlineFormCode == null ? other$onlineFormCode != null : !this$onlineFormCode.equals(other$onlineFormCode)) {
            return false;
        }
        String this$onlineFormDataId = this.getOnlineFormDataId();
        String other$onlineFormDataId = other.getOnlineFormDataId();
        if (this$onlineFormDataId == null ? other$onlineFormDataId != null : !this$onlineFormDataId.equals(other$onlineFormDataId)) {
            return false;
        }
        String this$bpmStatus = this.getBpmStatus();
        String other$bpmStatus = other.getBpmStatus();
        if (this$bpmStatus == null ? other$bpmStatus != null : !this$bpmStatus.equals(other$bpmStatus)) {
            return false;
        }
        String this$createBy = this.getCreateBy();
        String other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !this$createBy.equals(other$createBy)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updateBy = this.getUpdateBy();
        String other$updateBy = other.getUpdateBy();
        if (this$updateBy == null ? other$updateBy != null : !this$updateBy.equals(other$updateBy)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DesignFormDataVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTriggerProcess() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $desformId = this.getDesformId();
        result = result * 59 + ($desformId == null ? 43 : $desformId.hashCode());
        String $desformCode = this.getDesformCode();
        result = result * 59 + ($desformCode == null ? 43 : $desformCode.hashCode());
        String $desformName = this.getDesformName();
        result = result * 59 + ($desformName == null ? 43 : $desformName.hashCode());
        String $desformDataJson = this.getDesformDataJson();
        result = result * 59 + ($desformDataJson == null ? 43 : $desformDataJson.hashCode());
        JSONObject $desformData = this.getDesformData();
        result = result * 59 + ($desformData == null ? 43 : $desformData.hashCode());
        String $onlineFormCode = this.getOnlineFormCode();
        result = result * 59 + ($onlineFormCode == null ? 43 : $onlineFormCode.hashCode());
        String $onlineFormDataId = this.getOnlineFormDataId();
        result = result * 59 + ($onlineFormDataId == null ? 43 : $onlineFormDataId.hashCode());
        String $bpmStatus = this.getBpmStatus();
        result = result * 59 + ($bpmStatus == null ? 43 : $bpmStatus.hashCode());
        String $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : $createBy.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : $updateBy.hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "DesignFormDataVo(id=" + this.getId() + ", desformId=" + this.getDesformId() + ", desformCode=" + this.getDesformCode() + ", desformName=" + this.getDesformName() + ", desformDataJson=" + this.getDesformDataJson() + ", desformData=" + this.getDesformData() + ", onlineFormCode=" + this.getOnlineFormCode() + ", onlineFormDataId=" + this.getOnlineFormDataId() + ", bpmStatus=" + this.getBpmStatus() + ", createBy=" + this.getCreateBy() + ", createTime=" + this.getCreateTime() + ", updateBy=" + this.getUpdateBy() + ", updateTime=" + this.getUpdateTime() + ", isTriggerProcess=" + this.isTriggerProcess() + ")";
    }
}

