/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.rule.nacos.authority;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.AuthorityRuleEntity;
import com.alibaba.csp.sentinel.dashboard.rule.DynamicRuleProvider;
import com.alibaba.csp.sentinel.dashboard.rule.nacos.entity.AuthorityRuleCorrectEntity;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authorityRuleNacosProvider")
public class AuthorityRuleNacosProvider
implements DynamicRuleProvider<List<AuthorityRuleEntity>> {
    @Autowired
    private ConfigService configService;
    @Autowired
    private Converter<String, List<AuthorityRuleCorrectEntity>> converter;

    public List<AuthorityRuleEntity> getRules(String appName) throws Exception {
        String rules = this.configService.getConfig(appName + "-authority-rules", "SENTINEL_GROUP", 3000L);
        if (StringUtil.isEmpty((String)rules)) {
            return new ArrayList<AuthorityRuleEntity>();
        }
        List entityList = (List)this.converter.convert((Object)rules);
        return entityList.stream().map(rule -> {
            AuthorityRule authorityRule = new AuthorityRule();
            BeanUtils.copyProperties((Object)rule, (Object)authorityRule);
            AuthorityRuleEntity entity = AuthorityRuleEntity.fromAuthorityRule((String)rule.getApp(), (String)rule.getIp(), (Integer)rule.getPort(), (AuthorityRule)authorityRule);
            entity.setId(rule.getId());
            entity.setGmtCreate(rule.getGmtCreate());
            return entity;
        }).collect(Collectors.toList());
    }
}

