/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller.v2;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.controller.base.BaseRuleController;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.FlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.InMemoryRuleRepositoryAdapter;
import com.alibaba.csp.sentinel.dashboard.rule.DynamicRuleProvider;
import com.alibaba.csp.sentinel.dashboard.rule.DynamicRulePublisher;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/v2/flow"})
public class FlowControllerV2
extends BaseRuleController {
    private final Logger logger = LoggerFactory.getLogger(FlowControllerV2.class);
    @Autowired
    private InMemoryRuleRepositoryAdapter<FlowRuleEntity> repository;
    @Autowired
    @Qualifier(value="flowRuleNacosProvider")
    private DynamicRuleProvider<List<FlowRuleEntity>> ruleProvider;
    @Autowired
    @Qualifier(value="flowRuleNacosPublisher")
    private DynamicRulePublisher<List<FlowRuleEntity>> rulePublisher;

    @GetMapping(value={"/rules"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<FlowRuleEntity>> apiQueryMachineRules(@RequestParam String app) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        try {
            List rules = (List)this.ruleProvider.getRules(app);
            if (rules != null && !rules.isEmpty()) {
                for (FlowRuleEntity entity : rules) {
                    entity.setApp(app);
                    if (entity.getClusterConfig() == null || entity.getClusterConfig().getFlowId() == null) continue;
                    entity.setId(entity.getClusterConfig().getFlowId());
                }
            }
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            this.logger.error("Error when querying flow rules", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    private <R> Result<R> checkEntityInternal(FlowRuleEntity entity) {
        if (entity == null) {
            return Result.ofFail((int)-1, (String)"invalid body");
        }
        if (StringUtil.isBlank((String)entity.getApp())) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getLimitApp())) {
            return Result.ofFail((int)-1, (String)"limitApp can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getResource())) {
            return Result.ofFail((int)-1, (String)"resource can't be null or empty");
        }
        if (entity.getGrade() == null) {
            return Result.ofFail((int)-1, (String)"grade can't be null");
        }
        if (entity.getGrade() != 0 && entity.getGrade() != 1) {
            return Result.ofFail((int)-1, (String)("grade must be 0 or 1, but " + entity.getGrade() + " got"));
        }
        if (entity.getCount() == null || entity.getCount() < 0.0) {
            return Result.ofFail((int)-1, (String)"count should be at lease zero");
        }
        if (entity.getStrategy() == null) {
            return Result.ofFail((int)-1, (String)"strategy can't be null");
        }
        if (entity.getStrategy() != 0 && StringUtil.isBlank((String)entity.getRefResource())) {
            return Result.ofFail((int)-1, (String)"refResource can't be null or empty when strategy!=0");
        }
        if (entity.getControlBehavior() == null) {
            return Result.ofFail((int)-1, (String)"controlBehavior can't be null");
        }
        int controlBehavior = entity.getControlBehavior();
        if (controlBehavior == 1 && entity.getWarmUpPeriodSec() == null) {
            return Result.ofFail((int)-1, (String)"warmUpPeriodSec can't be null when controlBehavior==1");
        }
        if (controlBehavior == 2 && entity.getMaxQueueingTimeMs() == null) {
            return Result.ofFail((int)-1, (String)"maxQueueingTimeMs can't be null when controlBehavior==2");
        }
        if (entity.isClusterMode() && entity.getClusterConfig() == null) {
            return Result.ofFail((int)-1, (String)"cluster config should be valid");
        }
        return null;
    }

    @PostMapping(value={"/rule"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<FlowRuleEntity> apiAddFlowRule(@RequestBody FlowRuleEntity entity) {
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setId(null);
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        entity.setLimitApp(entity.getLimitApp().trim());
        entity.setResource(entity.getResource().trim());
        try {
            entity = (FlowRuleEntity)this.repository.save((RuleEntity)entity);
            this.publishRules(entity.getApp());
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to add flow rule", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        return Result.ofSuccess((Object)entity);
    }

    @PutMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<FlowRuleEntity> apiUpdateFlowRule(@PathVariable(value="id") Long id, @RequestBody FlowRuleEntity entity) {
        if (id == null || id <= 0L) {
            return Result.ofFail((int)-1, (String)"Invalid id");
        }
        FlowRuleEntity oldEntity = (FlowRuleEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " does not exist"));
        }
        if (entity == null) {
            return Result.ofFail((int)-1, (String)"invalid body");
        }
        entity.setApp(oldEntity.getApp());
        entity.setIp(oldEntity.getIp());
        entity.setPort(oldEntity.getPort());
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setId(id);
        Date date = new Date();
        entity.setGmtCreate(oldEntity.getGmtCreate());
        entity.setGmtModified(date);
        try {
            entity = (FlowRuleEntity)this.repository.save((RuleEntity)entity);
            if (entity == null) {
                return Result.ofFail((int)-1, (String)"save entity fail");
            }
            this.publishRules(oldEntity.getApp());
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to update flow rule", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        return Result.ofSuccess((Object)entity);
    }

    @DeleteMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> apiDeleteRule(@PathVariable(value="id") Long id) {
        if (id == null || id <= 0L) {
            return Result.ofFail((int)-1, (String)"Invalid id");
        }
        FlowRuleEntity oldEntity = (FlowRuleEntity)this.repository.findById(id);
        if (ObjectUtils.isEmpty((Object)oldEntity)) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
            this.publishRules(oldEntity.getApp());
        }
        catch (Exception e) {
            return Result.ofFail((int)-1, (String)e.getMessage());
        }
        return Result.ofSuccess((Object)id);
    }

    private void publishRules(String app) throws Exception {
        List rules = this.repository.findAllByApp(app);
        this.rulePublisher.publish(app, (Object)rules);
        FlowControllerV2.delayTime();
    }
}

