/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller.gateway;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.controller.base.BaseRuleController;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.GatewayFlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.GatewayParamFlowItemEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.rule.AddFlowRuleReqVo;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.rule.GatewayParamFlowItemVo;
import com.alibaba.csp.sentinel.dashboard.domain.vo.gateway.rule.UpdateFlowRuleReqVo;
import com.alibaba.csp.sentinel.dashboard.repository.gateway.InMemGatewayFlowRuleStore;
import com.alibaba.csp.sentinel.dashboard.rule.DynamicRuleProvider;
import com.alibaba.csp.sentinel.dashboard.rule.DynamicRulePublisher;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/gateway/flow"})
public class GatewayFlowRuleController
extends BaseRuleController {
    private final Logger logger = LoggerFactory.getLogger(GatewayFlowRuleController.class);
    @Autowired
    private InMemGatewayFlowRuleStore repository;
    @Autowired
    @Qualifier(value="gateWayFlowRulesNacosProvider")
    private DynamicRuleProvider<List<GatewayFlowRuleEntity>> ruleProvider;
    @Autowired
    @Qualifier(value="gateWayFlowRulesNacosPublisher")
    private DynamicRulePublisher<List<GatewayFlowRuleEntity>> rulePublisher;

    @GetMapping(value={"/list.json"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<GatewayFlowRuleEntity>> queryFlowRules(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        try {
            List rules = (List)this.ruleProvider.getRules(app);
            this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            this.logger.error("query gateway flow rules error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    @PostMapping(value={"/new.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<GatewayFlowRuleEntity> addFlowRule(@RequestBody AddFlowRuleReqVo reqVo) {
        Integer grade;
        String app = reqVo.getApp();
        if (StringUtil.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        GatewayFlowRuleEntity entity = new GatewayFlowRuleEntity();
        entity.setApp(app.trim());
        String ip = reqVo.getIp();
        if (StringUtil.isBlank((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        entity.setIp(ip.trim());
        Integer port = reqVo.getPort();
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        entity.setPort(port);
        Integer resourceMode = reqVo.getResourceMode();
        if (resourceMode == null) {
            return Result.ofFail((int)-1, (String)"resourceMode can't be null");
        }
        if (!Arrays.asList(0, 1).contains(resourceMode)) {
            return Result.ofFail((int)-1, (String)("invalid resourceMode: " + resourceMode));
        }
        entity.setResourceMode(resourceMode);
        String resource = reqVo.getResource();
        if (StringUtil.isBlank((String)resource)) {
            return Result.ofFail((int)-1, (String)"resource can't be null or empty");
        }
        entity.setResource(resource.trim());
        GatewayParamFlowItemVo paramItem = reqVo.getParamItem();
        if (paramItem != null) {
            String pattern;
            GatewayParamFlowItemEntity itemEntity = new GatewayParamFlowItemEntity();
            entity.setParamItem(itemEntity);
            Integer parseStrategy = paramItem.getParseStrategy();
            if (!Arrays.asList(0, 1, 2, 3, 4).contains(parseStrategy)) {
                return Result.ofFail((int)-1, (String)("invalid parseStrategy: " + parseStrategy));
            }
            itemEntity.setParseStrategy(paramItem.getParseStrategy());
            if (Arrays.asList(2, 3, 4).contains(parseStrategy)) {
                String fieldName = paramItem.getFieldName();
                if (StringUtil.isBlank((String)fieldName)) {
                    return Result.ofFail((int)-1, (String)"fieldName can't be null or empty");
                }
                itemEntity.setFieldName(paramItem.getFieldName());
            }
            if (StringUtil.isNotEmpty((String)(pattern = paramItem.getPattern()))) {
                itemEntity.setPattern(pattern);
                Integer matchStrategy = paramItem.getMatchStrategy();
                if (!Arrays.asList(0, 3, 2).contains(matchStrategy)) {
                    return Result.ofFail((int)-1, (String)("invalid matchStrategy: " + matchStrategy));
                }
                itemEntity.setMatchStrategy(matchStrategy);
            }
        }
        if ((grade = reqVo.getGrade()) == null) {
            return Result.ofFail((int)-1, (String)"grade can't be null");
        }
        if (!Arrays.asList(0, 1).contains(grade)) {
            return Result.ofFail((int)-1, (String)("invalid grade: " + grade));
        }
        entity.setGrade(grade);
        Double count = reqVo.getCount();
        if (count == null) {
            return Result.ofFail((int)-1, (String)"count can't be null");
        }
        if (count < 0.0) {
            return Result.ofFail((int)-1, (String)"count should be at lease zero");
        }
        entity.setCount(count);
        Long interval = reqVo.getInterval();
        if (interval == null) {
            return Result.ofFail((int)-1, (String)"interval can't be null");
        }
        if (interval <= 0L) {
            return Result.ofFail((int)-1, (String)"interval should be greater than zero");
        }
        entity.setInterval(interval);
        Integer intervalUnit = reqVo.getIntervalUnit();
        if (intervalUnit == null) {
            return Result.ofFail((int)-1, (String)"intervalUnit can't be null");
        }
        if (!Arrays.asList(0, 1, 2, 3).contains(intervalUnit)) {
            return Result.ofFail((int)-1, (String)("Invalid intervalUnit: " + intervalUnit));
        }
        entity.setIntervalUnit(intervalUnit);
        Integer controlBehavior = reqVo.getControlBehavior();
        if (controlBehavior == null) {
            return Result.ofFail((int)-1, (String)"controlBehavior can't be null");
        }
        if (!Arrays.asList(0, 2).contains(controlBehavior)) {
            return Result.ofFail((int)-1, (String)("invalid controlBehavior: " + controlBehavior));
        }
        entity.setControlBehavior(controlBehavior);
        if (0 == controlBehavior) {
            Integer burst = reqVo.getBurst();
            if (burst == null) {
                return Result.ofFail((int)-1, (String)"burst can't be null");
            }
            if (burst < 0) {
                return Result.ofFail((int)-1, (String)("invalid burst: " + burst));
            }
            entity.setBurst(burst);
        } else if (2 == controlBehavior) {
            Integer maxQueueingTimeoutMs = reqVo.getMaxQueueingTimeoutMs();
            if (maxQueueingTimeoutMs == null) {
                return Result.ofFail((int)-1, (String)"maxQueueingTimeoutMs can't be null");
            }
            if (maxQueueingTimeoutMs < 0) {
                return Result.ofFail((int)-1, (String)("invalid maxQueueingTimeoutMs: " + maxQueueingTimeoutMs));
            }
            entity.setMaxQueueingTimeoutMs(maxQueueingTimeoutMs);
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (GatewayFlowRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("add gateway flow rule error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, ip, port)) {
            this.logger.warn("publish gateway flow rules fail after add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @PostMapping(value={"/save.json"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<GatewayFlowRuleEntity> updateFlowRule(@RequestBody UpdateFlowRuleReqVo reqVo) {
        String app = reqVo.getApp();
        if (StringUtil.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        Long id = reqVo.getId();
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        GatewayFlowRuleEntity entity = (GatewayFlowRuleEntity)this.repository.findById(id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("gateway flow rule does not exist, id=" + id));
        }
        GatewayParamFlowItemVo paramItem = reqVo.getParamItem();
        if (paramItem != null) {
            String pattern;
            GatewayParamFlowItemEntity itemEntity = new GatewayParamFlowItemEntity();
            entity.setParamItem(itemEntity);
            Integer parseStrategy = paramItem.getParseStrategy();
            if (!Arrays.asList(0, 1, 2, 3, 4).contains(parseStrategy)) {
                return Result.ofFail((int)-1, (String)("invalid parseStrategy: " + parseStrategy));
            }
            itemEntity.setParseStrategy(paramItem.getParseStrategy());
            if (Arrays.asList(2, 3, 4).contains(parseStrategy)) {
                String fieldName = paramItem.getFieldName();
                if (StringUtil.isBlank((String)fieldName)) {
                    return Result.ofFail((int)-1, (String)"fieldName can't be null or empty");
                }
                itemEntity.setFieldName(paramItem.getFieldName());
            }
            if (StringUtil.isNotEmpty((String)(pattern = paramItem.getPattern()))) {
                itemEntity.setPattern(pattern);
                Integer matchStrategy = paramItem.getMatchStrategy();
                if (!Arrays.asList(0, 3, 2).contains(matchStrategy)) {
                    return Result.ofFail((int)-1, (String)("invalid matchStrategy: " + matchStrategy));
                }
                itemEntity.setMatchStrategy(matchStrategy);
            }
        } else {
            entity.setParamItem(null);
        }
        Integer grade = reqVo.getGrade();
        if (grade == null) {
            return Result.ofFail((int)-1, (String)"grade can't be null");
        }
        if (!Arrays.asList(0, 1).contains(grade)) {
            return Result.ofFail((int)-1, (String)("invalid grade: " + grade));
        }
        entity.setGrade(grade);
        Double count = reqVo.getCount();
        if (count == null) {
            return Result.ofFail((int)-1, (String)"count can't be null");
        }
        if (count < 0.0) {
            return Result.ofFail((int)-1, (String)"count should be at lease zero");
        }
        entity.setCount(count);
        Long interval = reqVo.getInterval();
        if (interval == null) {
            return Result.ofFail((int)-1, (String)"interval can't be null");
        }
        if (interval <= 0L) {
            return Result.ofFail((int)-1, (String)"interval should be greater than zero");
        }
        entity.setInterval(interval);
        Integer intervalUnit = reqVo.getIntervalUnit();
        if (intervalUnit == null) {
            return Result.ofFail((int)-1, (String)"intervalUnit can't be null");
        }
        if (!Arrays.asList(0, 1, 2, 3).contains(intervalUnit)) {
            return Result.ofFail((int)-1, (String)("Invalid intervalUnit: " + intervalUnit));
        }
        entity.setIntervalUnit(intervalUnit);
        Integer controlBehavior = reqVo.getControlBehavior();
        if (controlBehavior == null) {
            return Result.ofFail((int)-1, (String)"controlBehavior can't be null");
        }
        if (!Arrays.asList(0, 2).contains(controlBehavior)) {
            return Result.ofFail((int)-1, (String)("invalid controlBehavior: " + controlBehavior));
        }
        entity.setControlBehavior(controlBehavior);
        if (0 == controlBehavior) {
            Integer burst = reqVo.getBurst();
            if (burst == null) {
                return Result.ofFail((int)-1, (String)"burst can't be null");
            }
            if (burst < 0) {
                return Result.ofFail((int)-1, (String)("invalid burst: " + burst));
            }
            entity.setBurst(burst);
        } else if (2 == controlBehavior) {
            Integer maxQueueingTimeoutMs = reqVo.getMaxQueueingTimeoutMs();
            if (maxQueueingTimeoutMs == null) {
                return Result.ofFail((int)-1, (String)"maxQueueingTimeoutMs can't be null");
            }
            if (maxQueueingTimeoutMs < 0) {
                return Result.ofFail((int)-1, (String)("invalid maxQueueingTimeoutMs: " + maxQueueingTimeoutMs));
            }
            entity.setMaxQueueingTimeoutMs(maxQueueingTimeoutMs);
        }
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (GatewayFlowRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            this.logger.error("update gateway flow rule error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, entity.getIp(), entity.getPort())) {
            this.logger.warn("publish gateway flow rules fail after update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @PostMapping(value={"/delete.json"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> deleteFlowRule(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        GatewayFlowRuleEntity oldEntity = (GatewayFlowRuleEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Throwable throwable) {
            this.logger.error("delete gateway flow rule error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.warn("publish gateway flow rules fail after delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByApp(app);
        try {
            this.rulePublisher.publish(app, (Object)rules);
            GatewayFlowRuleController.delayTime();
            return true;
        }
        catch (Exception e) {
            this.logger.error("publish rules error!");
            e.printStackTrace();
            return false;
        }
    }
}

