/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.context.TestContext;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.ClassEvent;
import org.jboss.arquillian.test.spi.event.suite.SuiteEvent;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextHandler {
    @Inject
    private Instance<SuiteContext> suiteContextInstance;
    @Inject
    private Instance<ClassContext> classContextInstance;
    @Inject
    private Instance<TestContext> testContextInstance;
    @Inject
    @ClassScoped
    private InstanceProducer<TestClass> testClassProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSuiteContext(@Observes(precedence=100) EventContext<SuiteEvent> context) {
        SuiteContext suiteContext = (SuiteContext)this.suiteContextInstance.get();
        try {
            suiteContext.activate();
            context.proceed();
        }
        finally {
            suiteContext.deactivate();
            if (AfterSuite.class.isAssignableFrom(((SuiteEvent)context.getEvent()).getClass())) {
                suiteContext.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createClassContext(@Observes(precedence=100) EventContext<ClassEvent> context) {
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        try {
            classContext.activate((Object)((ClassEvent)context.getEvent()).getTestClass().getJavaClass());
            this.testClassProducer.set((Object)((ClassEvent)context.getEvent()).getTestClass());
            context.proceed();
        }
        finally {
            classContext.deactivate();
            if (AfterClass.class.isAssignableFrom(((ClassEvent)context.getEvent()).getClass())) {
                classContext.destroy((Object)((ClassEvent)context.getEvent()).getTestClass().getJavaClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestContext(@Observes(precedence=100) EventContext<TestEvent> context) {
        TestContext testContext = (TestContext)this.testContextInstance.get();
        try {
            testContext.activate(((TestEvent)context.getEvent()).getTestInstance());
            context.proceed();
        }
        finally {
            testContext.deactivate();
            if (After.class.isAssignableFrom(((TestEvent)context.getEvent()).getClass())) {
                testContext.destroy(((TestEvent)context.getEvent()).getTestInstance());
            }
        }
    }
}

